/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.tools.I18n;

public class AutoLoadTilesAction
extends AbstractAction
implements Layer.LayerAction {
    private final AbstractTileSourceLayer<?> layer;

    public AutoLoadTilesAction(AbstractTileSourceLayer<?> layer) {
        super(I18n.tr("Auto load tiles", new Object[0]));
        this.layer = layer;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        TileSourceDisplaySettings settings;
        settings.setAutoLoad(!(settings = this.layer.getDisplaySettings()).isAutoLoad());
    }

    @Override
    public Component createMenuComponent() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(this);
        item.setSelected(this.layer.getDisplaySettings().isAutoLoad());
        return item;
    }

    @Override
    public boolean supportLayers(List<Layer> layers) {
        return AbstractTileSourceLayer.actionSupportLayers(layers);
    }
}

