/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.stream;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.function.Supplier;
import uk.org.webcompere.systemstubs.resource.SingularTestResource;
import uk.org.webcompere.systemstubs.stream.StreamException;
import uk.org.webcompere.systemstubs.stream.output.Output;
import uk.org.webcompere.systemstubs.stream.output.OutputFactory;
import uk.org.webcompere.systemstubs.stream.output.TapStream;

public class SystemStreamBase
extends SingularTestResource
implements Output<OutputStream> {
    private static final boolean AUTO_FLUSH = true;
    private static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    protected PrintStream originalStream;
    protected Output<? extends OutputStream> currentTarget;
    protected OutputFactory<? extends OutputStream> targetFactory;
    protected Consumer<PrintStream> printStreamSetter;
    protected Supplier<PrintStream> printStreamGetter;

    protected <T extends OutputStream> SystemStreamBase(Consumer<PrintStream> printStreamSetter, Supplier<PrintStream> printStreamGetter) {
        this(new TapStream(), printStreamSetter, printStreamGetter);
    }

    protected <T extends OutputStream> SystemStreamBase(Output<T> target, Consumer<PrintStream> printStreamSetter, Supplier<PrintStream> printStreamGetter) {
        this(target.factoryOfSelf(), printStreamSetter, printStreamGetter);
    }

    protected <T extends OutputStream> SystemStreamBase(OutputFactory<T> targetFactory, Consumer<PrintStream> printStreamSetter, Supplier<PrintStream> printStreamGetter) {
        this.targetFactory = targetFactory;
        this.printStreamSetter = printStreamSetter;
        this.printStreamGetter = printStreamGetter;
    }

    public static PrintStream wrap(OutputStream outputStream) throws UnsupportedEncodingException {
        return new PrintStream(outputStream, true, DEFAULT_ENCODING);
    }

    @Override
    protected void doSetup() throws Exception {
        this.clear();
        this.originalStream = this.printStreamGetter.get();
        try {
            this.currentTarget = this.targetFactory.apply(this.originalStream);
            this.printStreamSetter.accept(SystemStreamBase.wrap(this.currentTarget.getOutputStream()));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException("Cannot wrap stream: " + e.getMessage(), e);
        }
    }

    @Override
    protected void doTeardown() throws Exception {
        this.printStreamSetter.accept(this.originalStream);
        this.currentTarget.closeOutput();
    }

    @Override
    public String getText() {
        return this.currentTarget.getText();
    }

    @Override
    public void clear() {
        if (this.currentTarget != null) {
            this.currentTarget.clear();
        }
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.currentTarget == null) {
            return null;
        }
        return this.currentTarget.getOutputStream();
    }
}

