/*
 * Copyright 2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.execution;

import org.gradle.internal.execution.workspace.MutableWorkspaceProvider;

/**
 * A unit of work that can be executed multiple times in the same workspace.
 * Such work can reuse outputs from a previous execution.
 */
public interface MutableUnitOfWork extends UnitOfWork {
    /**
     * Returns the {@link MutableWorkspaceProvider} to allocate a workspace to execution this work in.
     */
    MutableWorkspaceProvider getWorkspaceProvider();
}
