/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck.provider;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.unomi.healthcheck.HealthCheckConfig;
import org.apache.unomi.healthcheck.HealthCheckProvider;
import org.apache.unomi.healthcheck.HealthCheckResponse;
import org.apache.unomi.healthcheck.util.CachedValue;
import org.apache.unomi.shell.migration.utils.HttpUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheckProvider.class}, immediate=true)
public class ElasticSearchHealthCheckProvider
implements HealthCheckProvider {
    public static final String NAME = "elasticsearch";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ElasticSearchHealthCheckProvider.class.getName());
    private final CachedValue<HealthCheckResponse> cache = new CachedValue(10L, TimeUnit.SECONDS);
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    private HealthCheckConfig config;
    private CloseableHttpClient httpClient;

    public ElasticSearchHealthCheckProvider() {
        LOGGER.info("Building elasticsearch health provider service...");
    }

    @Activate
    public void activate() {
        LOGGER.info("Activating elasticsearch health provider service...");
        BasicCredentialsProvider credentialsProvider = null;
        String login = this.config.get("esLogin");
        if (StringUtils.isNotEmpty((CharSequence)login)) {
            credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(login, this.config.get("esPassword"));
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
        try {
            this.httpClient = HttpUtils.initHttpClient((boolean)Boolean.parseBoolean(this.config.get("httpClient.trustAllCertificates")), (CredentialsProvider)credentialsProvider);
        }
        catch (IOException e) {
            LOGGER.error("Unable to initialize http client", (Throwable)e);
        }
    }

    public void setConfig(HealthCheckConfig config) {
        this.config = config;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public HealthCheckResponse execute() {
        LOGGER.debug("Health check elasticsearch");
        if (this.cache.isStaled() || this.cache.getValue().isDown() || this.cache.getValue().isError()) {
            this.cache.setValue(this.refresh());
        }
        return this.cache.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HealthCheckResponse refresh() {
        LOGGER.debug("Refresh");
        HealthCheckResponse.Builder builder = new HealthCheckResponse.Builder();
        builder.name(NAME).down();
        String url = (this.config.get("esSSLEnabled").equals("true") ? "https://" : "http://").concat(this.config.get("esAddresses").split(",")[0].trim()).concat("/_cluster/health");
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)new HttpGet(url));
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                builder.up();
                HttpEntity entity = response.getEntity();
                if (entity != null && EntityUtils.toString((HttpEntity)entity).contains("\"status\":\"green\"")) {
                    builder.live();
                }
            }
        }
        catch (IOException e) {
            builder.error().withData("error", e.getMessage());
            LOGGER.error("Error while checking elasticsearch health", (Throwable)e);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
        return builder.build();
    }
}

