/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.exceptions;

import aQute.lib.exceptions.Exceptions;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface BiConsumerWithException<T, U> {
    public void accept(T var1, U var2) throws Exception;

    default public BiConsumer<T, U> orElseThrow() {
        return (t, u) -> {
            try {
                this.accept(t, u);
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        };
    }

    default public BiConsumer<T, U> ignoreException() {
        return (t, u) -> {
            try {
                this.accept(t, u);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    public static <T, U> BiConsumer<T, U> asBiConsumer(BiConsumerWithException<T, U> unchecked) {
        return unchecked.orElseThrow();
    }

    public static <T, U> BiConsumer<T, U> asBiConsumerIgnoreException(BiConsumerWithException<T, U> unchecked) {
        return unchecked.ignoreException();
    }
}

