/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util.functions;

import org.apache.commons.lang3.StringUtils;
import org.apache.torque.Column;
import org.apache.torque.util.functions.SQLFunction;

public class AggregateFunction
implements SQLFunction {
    private boolean distinct;
    private String function;
    private Column column;

    protected AggregateFunction(String function, Column column, boolean distinct) {
        if (StringUtils.isBlank((CharSequence)function)) {
            throw new IllegalArgumentException("function must not be null or blank");
        }
        this.function = function;
        this.setColumn(column);
        this.distinct = distinct;
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column must not be null");
        }
        this.column = column;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    protected String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        if (StringUtils.isBlank((CharSequence)function)) {
            throw new IllegalArgumentException("function must not be null or blank");
        }
        this.function = function;
    }

    @Override
    public String getSqlExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFunction()).append("(");
        if (this.isDistinct()) {
            sb.append("DISTINCT ");
        }
        sb.append(this.column.getSqlExpression()).append(")");
        return sb.toString();
    }

    @Override
    public Object getArgument(int i) {
        switch (i) {
            case 0: {
                return this.column;
            }
            case 1: {
                return this.distinct;
            }
        }
        return null;
    }

    @Override
    public Object[] getArguments() {
        return new Object[]{this.column, this.distinct};
    }

    @Override
    public void setArguments(Object ... args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("There must be at least one argument object specified!");
        }
        if (args.length < 2) {
            this.distinct = false;
        } else {
            if (!(args[1] instanceof Boolean)) {
                throw new IllegalArgumentException("Second argument object is not type Boolean!");
            }
            this.distinct = (Boolean)args[1];
        }
        if (!(args[0] instanceof Column)) {
            throw new IllegalArgumentException("First argument object is not type Column!");
        }
        this.column = (Column)args[0];
    }

    @Override
    public String getColumnName() {
        return null;
    }

    @Override
    public String getTableName() {
        return this.column.getTableName();
    }

    @Override
    public String getSchemaName() {
        return this.column.getSchemaName();
    }

    @Override
    public String getFullTableName() {
        return this.column.getFullTableName();
    }
}

