/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta.util;

import jakarta.mail.internet.InternetAddress;
import java.net.IDN;
import java.util.function.Function;

public class IDNEmailAddressConverter {
    private String getDomainPart(String email, int idx) {
        return email.substring(idx + 1);
    }

    private String getLocalPart(String email, int idx) {
        return email.substring(0, idx);
    }

    public String toASCII(String email) {
        return this.toString(email, IDN::toASCII);
    }

    private String toString(String email, Function<String, String> converter) {
        int idx;
        int n = idx = email == null ? -1 : email.indexOf(64);
        if (idx < 0) {
            return email;
        }
        return this.getLocalPart(email, idx) + '@' + converter.apply(this.getDomainPart(email, idx));
    }

    String toUnicode(InternetAddress address) {
        return address != null ? this.toUnicode(address.getAddress()) : null;
    }

    String toUnicode(String email) {
        return this.toString(email, IDN::toUnicode);
    }
}

