/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.activation.FileTypeMap;
import jakarta.activation.URLDataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.mail2.core.EmailException;
import org.apache.commons.mail2.core.EmailUtils;
import org.apache.commons.mail2.jakarta.Email;
import org.apache.commons.mail2.jakarta.EmailAttachment;
import org.apache.commons.mail2.jakarta.activation.PathDataSource;

public class MultiPartEmail
extends Email {
    private MimeMultipart container;
    private BodyPart primaryBodyPart;
    private String subType;
    private boolean initialized;
    private boolean hasAttachments;

    public Email addPart(MimeMultipart multipart) throws EmailException {
        try {
            return this.addPart(multipart, this.getContainer().getCount());
        }
        catch (MessagingException e) {
            throw new EmailException((Throwable)e);
        }
    }

    public Email addPart(MimeMultipart multipart, int index) throws EmailException {
        BodyPart bodyPart = this.createBodyPart();
        try {
            bodyPart.setContent((Multipart)multipart);
            this.getContainer().addBodyPart(bodyPart, index);
        }
        catch (MessagingException e) {
            throw new EmailException((Throwable)e);
        }
        return this;
    }

    public Email addPart(String partContent, String partContentType) throws EmailException {
        BodyPart bodyPart = this.createBodyPart();
        try {
            bodyPart.setContent((Object)partContent, partContentType);
            this.getContainer().addBodyPart(bodyPart);
        }
        catch (MessagingException e) {
            throw new EmailException((Throwable)e);
        }
        return this;
    }

    public MultiPartEmail attach(DataSource dataSource, String name, String description) throws EmailException {
        EmailException.checkNonNull((Object)dataSource, () -> "Invalid Datasource.");
        try (InputStream inputStream = dataSource.getInputStream();){
            EmailException.checkNonNull((Object)inputStream, () -> "Invalid Datasource.");
        }
        catch (IOException e) {
            throw new EmailException("Invalid Datasource.", (Throwable)e);
        }
        return this.attach(dataSource, name, description, "attachment");
    }

    public MultiPartEmail attach(DataSource dataSource, String name, String description, String disposition) throws EmailException {
        if (EmailUtils.isEmpty((String)name)) {
            name = dataSource.getName();
        }
        try {
            BodyPart bodyPart = this.createBodyPart();
            bodyPart.setDisposition(disposition);
            bodyPart.setFileName(MimeUtility.encodeText((String)name));
            bodyPart.setDescription(description);
            bodyPart.setDataHandler(new DataHandler(dataSource));
            this.getContainer().addBodyPart(bodyPart);
        }
        catch (MessagingException | UnsupportedEncodingException e) {
            throw new EmailException(e);
        }
        this.setBoolHasAttachments(true);
        return this;
    }

    public MultiPartEmail attach(EmailAttachment attachment) throws EmailException {
        EmailException.checkNonNull((Object)attachment, () -> "Invalid attachment.");
        MultiPartEmail result = null;
        URL url = attachment.getURL();
        if (url == null) {
            String fileName = null;
            try {
                fileName = attachment.getPath();
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new IOException("\"" + fileName + "\" does not exist");
                }
                result = this.attach((DataSource)new FileDataSource(file), attachment.getName(), attachment.getDescription(), attachment.getDisposition());
            }
            catch (IOException e) {
                throw new EmailException("Cannot attach file \"" + fileName + "\"", (Throwable)e);
            }
        } else {
            result = this.attach(url, attachment.getName(), attachment.getDescription(), attachment.getDisposition());
        }
        return result;
    }

    public MultiPartEmail attach(File file) throws EmailException {
        String fileName = file.getAbsolutePath();
        try {
            if (!file.exists()) {
                throw new IOException("\"" + fileName + "\" does not exist");
            }
            return this.attach((DataSource)new FileDataSource(file), file.getName(), null, "attachment");
        }
        catch (IOException e) {
            throw new EmailException("Cannot attach file \"" + fileName + "\"", (Throwable)e);
        }
    }

    public MultiPartEmail attach(Path file, OpenOption ... options) throws EmailException {
        Path fileName = file.toAbsolutePath();
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                throw new IOException("\"" + fileName + "\" does not exist");
            }
            return this.attach(new PathDataSource(file, FileTypeMap.getDefaultFileTypeMap(), options), Objects.toString(file.getFileName(), null), null, "attachment");
        }
        catch (IOException e) {
            throw new EmailException("Cannot attach file \"" + fileName + "\"", (Throwable)e);
        }
    }

    public MultiPartEmail attach(URL url, String name, String description) throws EmailException {
        return this.attach(url, name, description, "attachment");
    }

    public MultiPartEmail attach(URL url, String name, String description, String disposition) throws EmailException {
        try {
            url.openStream().close();
        }
        catch (IOException e) {
            throw new EmailException("Invalid URL set:" + url, (Throwable)e);
        }
        return this.attach((DataSource)new URLDataSource(url), name, description, disposition);
    }

    @Override
    public void buildMimeMessage() throws EmailException {
        try {
            if (this.primaryBodyPart != null) {
                BodyPart body = this.getPrimaryBodyPart();
                try {
                    body.getContent();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.subType != null) {
                this.getContainer().setSubType(this.subType);
            }
            super.buildMimeMessage();
        }
        catch (MessagingException e) {
            throw new EmailException((Throwable)e);
        }
    }

    protected BodyPart createBodyPart() {
        return new MimeBodyPart();
    }

    protected MimeMultipart createMimeMultipart() {
        return new MimeMultipart();
    }

    protected MimeMultipart getContainer() {
        if (!this.initialized) {
            this.init();
        }
        return this.container;
    }

    protected BodyPart getPrimaryBodyPart() throws MessagingException {
        if (!this.initialized) {
            this.init();
        }
        if (this.primaryBodyPart == null) {
            this.primaryBodyPart = this.createBodyPart();
            this.getContainer().addBodyPart(this.primaryBodyPart, 0);
        }
        return this.primaryBodyPart;
    }

    public String getSubType() {
        return this.subType;
    }

    protected void init() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.container = this.createMimeMultipart();
        super.setContent(this.container);
        this.initialized = true;
    }

    public boolean isBoolHasAttachments() {
        return this.hasAttachments;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public void setBoolHasAttachments(boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public Email setMsg(String msg) throws EmailException {
        EmailException.checkNonEmpty((String)msg, () -> "Invalid message.");
        try {
            BodyPart primary = this.getPrimaryBodyPart();
            if (primary instanceof MimePart && EmailUtils.isNotEmpty((String)this.getCharsetName())) {
                ((MimePart)primary).setText(msg, this.getCharsetName());
            } else {
                primary.setText(msg);
            }
        }
        catch (MessagingException e) {
            throw new EmailException((Throwable)e);
        }
        return this;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }
}

