/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.fulcrum.parser.BaseValueParser;
import org.apache.fulcrum.parser.DefaultCookieParser;
import org.apache.fulcrum.parser.DefaultParameterParser;
import org.apache.fulcrum.parser.ParserService;
import org.apache.fulcrum.parser.ParserServiceSupport;
import org.apache.fulcrum.parser.ValueParser;
import org.apache.fulcrum.parser.pool.BaseValueParserFactory;
import org.apache.fulcrum.parser.pool.BaseValueParserPool;
import org.apache.fulcrum.parser.pool.CookieParserFactory;
import org.apache.fulcrum.parser.pool.CookieParserPool;
import org.apache.fulcrum.parser.pool.DefaultParameterParserFactory;
import org.apache.fulcrum.parser.pool.DefaultParameterParserPool;
import org.apache.fulcrum.pool.PoolException;
import org.apache.fulcrum.pool.PoolService;

public class DefaultParserService
extends AbstractLogEnabled
implements ParserService,
Configurable,
Serviceable {
    private ValueParser.URLCaseFolding folding = ValueParser.URLCaseFolding.NONE;
    private boolean automaticUpload = false;
    private String parameterEncoding = "ISO-8859-1";
    private boolean useFulcrumPool = false;
    private PoolService fulcrumPoolService = null;
    private BaseValueParserPool valueParserPool;
    private DefaultParameterParserPool parameterParserPool;
    private CookieParserPool cookieParserPool;

    public DefaultParserService() {
    }

    public DefaultParserService(GenericObjectPoolConfig<?> config) {
        this.valueParserPool = new BaseValueParserPool((PooledObjectFactory<BaseValueParser>)new BaseValueParserFactory(), config);
        this.parameterParserPool = new DefaultParameterParserPool((PooledObjectFactory<DefaultParameterParser>)new DefaultParameterParserFactory(), config);
    }

    @Override
    public String getParameterEncoding() {
        return this.parameterEncoding;
    }

    public void setParameterEncoding(String encoding) {
        this.parameterEncoding = encoding;
    }

    @Override
    public String convert(String value) {
        return this.convertAndTrim(value);
    }

    @Override
    public String convertAndTrim(String value) {
        return this.convertAndTrim(value, this.getUrlFolding());
    }

    @Override
    public String convertAndTrim(String value, ValueParser.URLCaseFolding fold) {
        if (value == null) {
            return "";
        }
        String tmp = value.trim();
        switch (fold) {
            case NONE: {
                break;
            }
            case LOWER: {
                tmp = tmp.toLowerCase();
                break;
            }
            case UPPER: {
                tmp = tmp.toUpperCase();
                break;
            }
            default: {
                this.getLogger().error("Passed " + String.valueOf((Object)fold) + " as fold rule, which is illegal!");
            }
        }
        return tmp;
    }

    @Override
    public ValueParser.URLCaseFolding getUrlFolding() {
        return this.folding;
    }

    @Override
    public boolean getAutomaticUpload() {
        return this.automaticUpload;
    }

    @Override
    public List<Part> parseUpload(HttpServletRequest request) throws ServiceException {
        try {
            return new ArrayList<Part>(request.getParts());
        }
        catch (ServletException | IOException e) {
            throw new ServiceException(ParserService.ROLE, "Could not parse upload request", e);
        }
    }

    @Override
    public <P extends ValueParser> P getParser(Class<P> ppClass) throws InstantiationException {
        ValueParser vp = null;
        try {
            block25: {
                if (this.useFulcrumPool) {
                    try {
                        ValueParser parserInstance;
                        vp = parserInstance = (ValueParser)this.fulcrumPoolService.getInstance(ppClass);
                    }
                    catch (PoolException pe) {
                        throw new InstantiationException("Parser class '" + String.valueOf(ppClass) + "' is illegal. " + pe.getMessage());
                    }
                }
                if (ppClass.equals(BaseValueParser.class)) {
                    BaseValueParser parserInstance = null;
                    try {
                        parserInstance = (BaseValueParser)this.valueParserPool.borrowObject();
                        vp = parserInstance;
                        if (vp == null) {
                            throw new InstantiationException("Could not borrow object from pool: " + String.valueOf((Object)this.valueParserPool));
                        }
                        break block25;
                    }
                    catch (Exception e) {
                        try {
                            this.valueParserPool.invalidateObject(parserInstance);
                            parserInstance = null;
                            break block25;
                        }
                        catch (Exception e1) {
                            throw new InstantiationException("Could not invalidate object " + e1.getMessage() + " after exception: " + e.getMessage());
                        }
                    }
                }
                if (ppClass.equals(DefaultParameterParser.class)) {
                    DefaultParameterParser parserInstance = null;
                    try {
                        parserInstance = (DefaultParameterParser)this.parameterParserPool.borrowObject();
                        vp = parserInstance;
                        if (vp == null) {
                            throw new InstantiationException("Could not borrow object from pool: " + String.valueOf((Object)this.parameterParserPool));
                        }
                        break block25;
                    }
                    catch (Exception e) {
                        try {
                            this.parameterParserPool.invalidateObject(parserInstance);
                            parserInstance = null;
                            break block25;
                        }
                        catch (Exception e1) {
                            throw new InstantiationException("Could not invalidate object " + e1.getMessage() + " after exception: " + e.getMessage());
                        }
                    }
                }
                if (ppClass.equals(DefaultCookieParser.class)) {
                    DefaultCookieParser parserInstance = null;
                    try {
                        parserInstance = (DefaultCookieParser)this.cookieParserPool.borrowObject();
                        vp = parserInstance;
                        if (vp == null) {
                            throw new InstantiationException("Could not borrow object from pool: " + String.valueOf((Object)this.cookieParserPool));
                        }
                    }
                    catch (Exception e) {
                        try {
                            this.cookieParserPool.invalidateObject(parserInstance);
                            parserInstance = null;
                        }
                        catch (Exception e1) {
                            throw new InstantiationException("Could not invalidate object " + e1.getMessage() + " after exception: " + e.getMessage());
                        }
                    }
                }
            }
            if (vp == null || !(vp instanceof ParserServiceSupport)) {
                throw new InstantiationException("Could not set parser");
            }
            ((ParserServiceSupport)((Object)vp)).setParserService(this);
            if (vp instanceof LogEnabled) {
                ((LogEnabled)vp).enableLogging(this.getLogger().getChildLogger(ppClass.getSimpleName()));
            }
        }
        catch (ClassCastException x) {
            throw new InstantiationException("Parser class '" + String.valueOf(ppClass) + "' is illegal. " + x.getMessage());
        }
        return (P)vp;
    }

    @Override
    public void putParser(ValueParser parser) {
        parser.clear();
        parser.dispose();
        if (this.useFulcrumPool) {
            this.fulcrumPoolService.putInstance((Object)parser);
        } else if (parser.getClass().equals(BaseValueParser.class)) {
            this.valueParserPool.returnObject((BaseValueParser)parser);
        } else if (parser.getClass().equals(DefaultParameterParser.class) || parser instanceof DefaultParameterParser) {
            this.parameterParserPool.returnObject((DefaultParameterParser)parser);
        } else if (parser.getClass().equals(DefaultCookieParser.class) || parser instanceof DefaultCookieParser) {
            this.cookieParserPool.returnObject((DefaultCookieParser)parser);
        } else {
            this.getLogger().warn(String.valueOf(parser.getClass()) + " could not be put back into any pool exhausting some pool");
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        String foldString = conf.getChild("urlCaseFolding").getValue(ValueParser.URLCaseFolding.NONE.name()).toLowerCase();
        this.folding = ValueParser.URLCaseFolding.NONE;
        this.getLogger().debug("Setting folding from " + foldString);
        if (StringUtils.isNotEmpty((CharSequence)foldString)) {
            try {
                this.folding = ValueParser.URLCaseFolding.valueOf(foldString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().error("Got " + foldString + " from urlCaseFolding property, which is illegal!");
                throw new ConfigurationException("Value " + foldString + " is illegal!", (Throwable)e);
            }
        }
        this.parameterEncoding = conf.getChild("parameterEncoding").getValue("ISO-8859-1").toLowerCase();
        this.automaticUpload = conf.getChild("automaticUpload").getValueAsBoolean(false);
        this.useFulcrumPool = conf.getChild("fulcrumPool").getValueAsBoolean(false);
        if (this.useFulcrumPool) {
            if (this.fulcrumPoolService == null) {
                throw new ConfigurationException("Fulcrum Pool is activated", (Throwable)new ServiceException(ParserService.ROLE, "Fulcrum enabled Pool Service requires " + PoolService.ROLE + " to be available"));
            }
            this.getLogger().info("Using Fulcrum Pool Service: " + String.valueOf(this.fulcrumPoolService));
        } else {
            this.fulcrumPoolService = null;
            GenericObjectPoolConfig config = new GenericObjectPoolConfig();
            config.setMaxIdle(2);
            config.setMaxTotal(1024);
            this.valueParserPool = new BaseValueParserPool((PooledObjectFactory<BaseValueParser>)new BaseValueParserFactory(), config);
            this.parameterParserPool = new DefaultParameterParserPool((PooledObjectFactory<DefaultParameterParser>)new DefaultParameterParserFactory(), config);
            this.cookieParserPool = new CookieParserPool((PooledObjectFactory<DefaultCookieParser>)new CookieParserFactory(), config);
            this.getLogger().info("Init Commons2 Pool Services..");
            this.getLogger().info(((Object)((Object)this.valueParserPool)).getClass().getName());
            this.getLogger().info(((Object)((Object)this.parameterParserPool)).getClass().getName());
            this.getLogger().info(((Object)((Object)this.cookieParserPool)).getClass().getName());
        }
        Configuration[] poolChildren = conf.getChild("pool2").getChildren();
        if (poolChildren.length > 0) {
            GenericObjectPoolConfig genObjPoolConfig = new GenericObjectPoolConfig();
            genObjPoolConfig.setMaxIdle(2);
            genObjPoolConfig.setMaxTotal(1024);
            block22: for (Configuration poolConf : poolChildren) {
                switch (poolConf.getName()) {
                    case "maxTotal": {
                        int defaultCapacity = poolConf.getValueAsInteger();
                        genObjPoolConfig.setMaxTotal(defaultCapacity);
                        continue block22;
                    }
                    case "maxWaitMillis": {
                        int maxWaitMillis = poolConf.getValueAsInteger();
                        Duration maxWaitMillisDuration = Duration.ofMillis(maxWaitMillis);
                        genObjPoolConfig.setMaxWait(maxWaitMillisDuration);
                        continue block22;
                    }
                    case "blockWhenExhausted": {
                        boolean blockWhenExhausted = poolConf.getValueAsBoolean();
                        genObjPoolConfig.setBlockWhenExhausted(blockWhenExhausted);
                        continue block22;
                    }
                    case "maxIdle": {
                        int maxIdle = poolConf.getValueAsInteger();
                        genObjPoolConfig.setMaxIdle(maxIdle);
                        continue block22;
                    }
                    case "minIdle": {
                        int minIdle = poolConf.getValueAsInteger();
                        genObjPoolConfig.setMinIdle(minIdle);
                        continue block22;
                    }
                    case "testOnReturn": {
                        boolean testOnReturn = poolConf.getValueAsBoolean();
                        genObjPoolConfig.setTestOnReturn(testOnReturn);
                        continue block22;
                    }
                    case "testOnBorrow": {
                        boolean testOnBorrow = poolConf.getValueAsBoolean();
                        genObjPoolConfig.setTestOnBorrow(testOnBorrow);
                        continue block22;
                    }
                    case "testOnCreate": {
                        boolean testOnCreate = poolConf.getValueAsBoolean();
                        genObjPoolConfig.setTestOnCreate(testOnCreate);
                        continue block22;
                    }
                }
            }
            if (!genObjPoolConfig.getBlockWhenExhausted() && !genObjPoolConfig.getMaxWaitDuration().isZero()) {
                this.getLogger().warn("maxWaitMillis will only be applied, if blockWhenExhausted is set. maxWait: " + String.valueOf(genObjPoolConfig.getMaxWaitDuration()));
            }
            this.valueParserPool.setConfig(genObjPoolConfig);
            this.parameterParserPool.setConfig(genObjPoolConfig);
            this.cookieParserPool.setConfig(genObjPoolConfig);
            this.getLogger().info("Update Config Commons2 Pools with " + String.valueOf(genObjPoolConfig));
            this.getLogger().debug(this.valueParserPool.toString());
            this.getLogger().debug(this.parameterParserPool.toString());
            this.getLogger().debug(this.cookieParserPool.toString());
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        if (manager.hasService(PoolService.ROLE)) {
            this.fulcrumPoolService = (PoolService)manager.lookup(PoolService.ROLE);
        }
    }
}

