/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.template;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TemplateService;

public class TemplateNavigation {
    private static final Logger log = LogManager.getLogger(TemplateNavigation.class);
    private final PipelineData pipelineData;
    private String template = null;

    public TemplateNavigation(PipelineData pipelineData) {
        this.pipelineData = pipelineData;
    }

    public TemplateNavigation setTemplate(String template) {
        log.debug("setTemplate({})", (Object)template);
        this.template = template;
        return this;
    }

    public String toString() {
        String module = null;
        Object returnValue = null;
        try {
            if (this.template == null) {
                returnValue = "Navigation Template is null (Might be unset)";
                throw new Exception((String)returnValue);
            }
            this.pipelineData.getRunData().getTemplateInfo().setNavigationTemplate(this.template);
            TemplateService templateService = (TemplateService)TurbineServices.getInstance().getService("TemplateService");
            module = templateService.getNavigationName(this.template);
            if (module == null) {
                returnValue = "Template Service returned null for Navigation Template " + this.template;
                throw new Exception((String)returnValue);
            }
            returnValue = NavigationLoader.getInstance().eval(this.pipelineData, module);
        }
        catch (Exception e) {
            if (returnValue == null) {
                returnValue = "Error processing navigation template: " + this.template + ", using module: " + module;
            }
            log.error((String)returnValue, (Throwable)e);
        }
        return returnValue;
    }
}

