/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.localization.DateTimeFormatterInterface;
import org.apache.turbine.util.LocaleUtils;

@TurbineService(value="DateTimeFormatterService")
public class DateTimeFormatterService
extends TurbineBaseService
implements DateTimeFormatterInterface {
    private String formatPattern = null;
    private DateTimeFormatter dateTimeFormat = null;
    private Locale locale = null;
    private ZoneId zoneId;
    private static final Logger log = LogManager.getLogger(DateTimeFormatterService.class);

    @Override
    public DateTimeFormatter getDefaultFormat() {
        return this.dateTimeFormat;
    }

    @Override
    public String getFormatPattern() {
        return this.formatPattern;
    }

    @Override
    public void init() {
        this.formatPattern = Turbine.getConfiguration().getString("datetime.format", "MM/dd/yyyy");
        boolean useTurbineLocale = Turbine.getConfiguration().getBoolean("datetime.use.turbine.locale", true);
        Locale localeSetter = useTurbineLocale && LocaleUtils.getDefaultLocale() != null ? LocaleUtils.getDefaultLocale() : Locale.getDefault();
        this.setLocale(localeSetter);
        String zoneIdStr = Turbine.getConfiguration().getString("datetime.zoneId");
        ZoneId zoneIdSet = zoneIdStr != null ? ZoneId.of(zoneIdStr) : ZoneId.systemDefault();
        this.setZoneId(zoneIdSet);
        this.dateTimeFormat = DateTimeFormatter.ofPattern(this.formatPattern).withLocale(localeSetter).withZone(zoneIdSet);
        log.info("Initialized DateTimeFormatterService with pattern {}, locale {} and zone {}", (Object)this.formatPattern, (Object)this.dateTimeFormat.getLocale(), (Object)this.dateTimeFormat.getZone());
        this.setInit(true);
    }

    @Override
    public <T extends TemporalAccessor> String format(T temporalAccessor) {
        return this.dateTimeFormat.format(temporalAccessor);
    }

    @Override
    public <T extends TemporalAccessor> String format(T temporalAccessor, String dateFormatString) {
        return this.format(temporalAccessor, dateFormatString, null, null);
    }

    @Override
    public <T extends TemporalAccessor> String format(T temporalAccessor, String dateFormatString, Locale locale) {
        return this.format(temporalAccessor, dateFormatString, locale, null);
    }

    @Override
    public <T extends TemporalAccessor> String format(T temporalAccessor, String dateFormatString, Locale locale, ZoneId zoneId) {
        String result = null;
        if (StringUtils.isEmpty((CharSequence)dateFormatString) || temporalAccessor == null) {
            result = "";
        } else {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(dateFormatString);
            if (locale != null) {
                dtf = dtf.withLocale(locale);
            } else {
                log.warn("adding default locale {}", (Object)this.getLocale());
                dtf = dtf.withLocale(this.getLocale());
            }
            if (zoneId != null) {
                dtf = dtf.withZone(zoneId);
            } else {
                log.info("adding default zone {}", (Object)this.getZoneId());
                dtf = dtf.withZone(this.getZoneId());
            }
            log.info("try to format {} with {}.", temporalAccessor, (Object)dtf);
            try {
                result = dtf.format(temporalAccessor);
            }
            catch (DateTimeException e) {
                log.error("An exception with date time formatting was thrown: {}", (Throwable)e);
                throw e;
            }
        }
        return result;
    }

    @Override
    public String map(String src, String outgoingFormatPattern, Locale locale, String incomingFormatPattern) {
        if (StringUtils.isEmpty((CharSequence)src) || outgoingFormatPattern == null) {
            return "";
        }
        if (incomingFormatPattern == null) {
            incomingFormatPattern = this.formatPattern;
        }
        if (incomingFormatPattern.equals(outgoingFormatPattern)) {
            return "";
        }
        DateTimeFormatter incomingFormat = DateTimeFormatter.ofPattern(incomingFormatPattern);
        DateTimeFormatter outgoingFormat = DateTimeFormatter.ofPattern(outgoingFormatPattern);
        if (locale != null) {
            outgoingFormat = outgoingFormat.withLocale(locale);
        }
        return this.map(src, outgoingFormat, locale, incomingFormat);
    }

    @Override
    public String map(String src, DateTimeFormatter outgoingFormat, Locale locale, DateTimeFormatter incomingFormat) {
        if (StringUtils.isEmpty((CharSequence)src) || outgoingFormat == null) {
            return "";
        }
        if (incomingFormat == null) {
            incomingFormat = this.dateTimeFormat;
        }
        if (incomingFormat.equals(outgoingFormat)) {
            return "";
        }
        if (locale != null) {
            outgoingFormat = outgoingFormat.withLocale(locale);
        }
        return outgoingFormat.format(incomingFormat.parse(src));
    }

    @Override
    public String mapTo(String src, DateTimeFormatter outgoingFormat) {
        return this.map(src, outgoingFormat, null, this.dateTimeFormat);
    }

    @Override
    public String mapFrom(String src, DateTimeFormatter incomingFormat) {
        return this.map(src, this.dateTimeFormat, null, incomingFormat);
    }

    @Override
    public String map(String src, DateTimeFormatter outgoingFormat, Locale locale) {
        return this.map(src, outgoingFormat, locale, this.dateTimeFormat);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

