/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.collections.prefixmap;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nl.basjes.collections.PrefixMap;
import nl.basjes.collections.prefixmap.PrefixTrie;
import nl.basjes.collections.prefixmap.StringPrefixTrie;

@DefaultSerializer(value=KryoSerializer.class)
public class StringPrefixMap<V extends Serializable>
implements PrefixMap<V>,
Serializable {
    private final Boolean caseSensitive;
    private final PrefixTrie<V> prefixTrie;
    private final TreeMap<String, V> allPrefixes;

    PrefixTrie<V> createTrie(boolean newCaseSensitive) {
        return new StringPrefixTrie(newCaseSensitive);
    }

    public StringPrefixMap(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.prefixTrie = this.createTrie(caseSensitive);
        this.allPrefixes = new TreeMap();
    }

    public static void configureKryo(Object kryoInstance) {
        Kryo kryo = (Kryo)kryoInstance;
        kryo.register(StringPrefixMap.class);
        kryo.register(StringPrefixTrie.class);
        kryo.register(TreeMap.class);
    }

    @Override
    public boolean containsPrefix(String prefix) {
        return this.prefixTrie.containsPrefix(prefix);
    }

    private String storedKey(String key) {
        if (this.prefixTrie.caseSensitive()) {
            return key;
        }
        return key.toLowerCase();
    }

    @Override
    public V put(String prefix, V value) {
        if (prefix == null) {
            throw new NullPointerException("The prefix may not be null");
        }
        if (value == null) {
            throw new NullPointerException("The value may not be null");
        }
        V previousValue = this.prefixTrie.add(prefix, value);
        if (previousValue == null) {
            this.allPrefixes.put(this.storedKey(prefix), value);
        }
        return previousValue;
    }

    @Override
    public int size() {
        return this.allPrefixes.size();
    }

    @Override
    public void clear() {
        this.prefixTrie.clear();
        this.allPrefixes.clear();
    }

    @Override
    public V remove(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("The prefix may not be null");
        }
        V oldValue = this.prefixTrie.remove(prefix);
        if (oldValue != null) {
            this.allPrefixes.remove(this.storedKey(prefix));
        }
        return oldValue;
    }

    @Override
    public V get(String prefix) {
        return this.prefixTrie.get(prefix);
    }

    @Override
    public V getShortestMatch(String input) {
        return this.prefixTrie.getShortestMatch(input);
    }

    @Override
    public V getLongestMatch(String input) {
        return this.prefixTrie.getLongestMatch(input);
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.allPrefixes.entrySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.allPrefixes.containsKey(this.storedKey((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.allPrefixes.containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.allPrefixes.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.allPrefixes.values();
    }

    public static class KryoSerializer
    extends Serializer<StringPrefixMap<Serializable>> {
        public void write(Kryo kryo, Output output, StringPrefixMap<Serializable> instance) {
            output.writeBoolean(((StringPrefixMap)instance).caseSensitive.booleanValue());
            kryo.writeClassAndObject(output, (Object)((StringPrefixMap)instance).allPrefixes);
        }

        public StringPrefixMap<Serializable> read(Kryo kryo, Input input, Class<? extends StringPrefixMap<Serializable>> type) {
            try {
                boolean caseSensitive = input.readBoolean();
                StringPrefixMap<Serializable> instance = type.getDeclaredConstructor(Boolean.TYPE).newInstance(caseSensitive);
                TreeMap allPrefixes = (TreeMap)kryo.readClassAndObject(input);
                for (Map.Entry entry : allPrefixes.entrySet()) {
                    Serializable value = (Serializable)entry.getValue();
                    instance.put((String)entry.getKey(), value);
                }
                return instance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new KryoException("Deserialization of StringPrefixMap failed", (Throwable)e);
            }
        }
    }
}

