/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.bval;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.bval.jsr.descriptor.ConstraintD;

public class MethodConstraints
implements Comparable<MethodConstraints> {
    final Set<Class<?>> annotations = new HashSet();
    final Method method;

    public MethodConstraints(Method method) {
        Objects.requireNonNull(method, "method cannot be null");
        this.method = method;
    }

    public void add(ConstraintD<?> constraint) {
        this.annotations.add(constraint.getAnnotation().annotationType());
    }

    public Set<Class<?>> getAnnotations() {
        return this.annotations;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public int compareTo(MethodConstraints that) {
        String signatureA = this.signature(that.method);
        String signatureB = this.signature(this.method);
        return signatureB.compareTo(signatureA);
    }

    private String signature(Method method) {
        String desc = method.toString();
        return desc.substring(desc.indexOf(method.getName()));
    }

    public String toString() {
        return this.signature(this.method);
    }
}

