/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceElement;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceProperty;

public class ReferencePath
extends MutablePath
implements Attachable<Path> {
    private ReferencePath() {
    }

    @Override
    public Path get() {
        return this;
    }

    protected ReferencePath(Path path) {
        path.forEach((Object object, Set<String> labels) -> {
            if (object instanceof ReferenceElement || object instanceof ReferenceProperty || object instanceof ReferencePath) {
                this.objects.add(object);
            } else {
                this.objects.add(ReferenceFactory.detach(object));
            }
            this.labels.add(new HashSet(labels));
        });
    }

    @Override
    public Path attach(Function<Attachable<Path>, Path> method) {
        Path path = MutablePath.make();
        this.forEach((Object object, Set<String> labels) -> path.extend(object instanceof Attachable ? ((Attachable)object).attach(method) : object, (Set<String>)labels));
        return path;
    }
}

