/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import java.io.Serializable;
import org.apache.tinkerpop.gremlin.process.computer.util.ComputerGraph;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public abstract class ReferenceElement<E extends Element>
implements Element,
Serializable,
Attachable<E> {
    protected Object id;
    protected String label;

    protected ReferenceElement() {
    }

    protected ReferenceElement(Object id, String label) {
        this.id = id;
        this.label = label;
    }

    public ReferenceElement(Element element) {
        this.id = element.id();
        try {
            this.label = element instanceof ComputerGraph.ComputerAdjacentVertex ? "vertex" : element.label();
        }
        catch (UnsupportedOperationException e) {
            this.label = element instanceof Vertex ? "vertex" : (element instanceof Edge ? "edge" : "vertexProperty");
        }
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public Graph graph() {
        return EmptyGraph.instance();
    }

    public int hashCode() {
        return ElementHelper.hashCode(this);
    }

    public boolean equals(Object other) {
        return ElementHelper.areEqual(this, other);
    }

    @Override
    public E get() {
        return (E)this;
    }
}

