/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import javax.measure.Unit;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.legacy.LegacyPropertyAdapter;
import org.apache.sis.util.internal.CodeLists;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gco.GO_Real;
import org.apache.sis.xml.bind.metadata.CI_Citation;
import org.apache.sis.xml.bind.metadata.MD_Identifier;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Medium;
import org.opengis.metadata.distribution.MediumFormat;
import org.opengis.metadata.distribution.MediumName;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Medium_Type", propOrder={"identifier", "name", "newName", "density", "densities", "densityUnits", "volumes", "mediumFormats", "mediumNote"})
@XmlRootElement(name="MD_Medium")
public class DefaultMedium
extends ISOMetadata
implements Medium {
    private static final long serialVersionUID = 7751002701087451894L;
    private MediumName name;
    private Collection<Double> densities;
    private Unit<?> densityUnits;
    private Integer volumes;
    private Collection<MediumFormat> mediumFormats;
    private InternationalString mediumNote;

    public DefaultMedium() {
    }

    public DefaultMedium(Medium object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.densities = this.copyCollection(object.getDensities(), Double.class);
            this.densityUnits = object.getDensityUnits();
            this.volumes = object.getVolumes();
            this.mediumFormats = this.copyCollection(object.getMediumFormats(), MediumFormat.class);
            this.mediumNote = object.getMediumNote();
            if (object instanceof DefaultMedium) {
                this.identifiers = this.singleton(((DefaultMedium)object).getIdentifier(), Identifier.class);
            }
        }
    }

    public static DefaultMedium castOrCopy(Medium object) {
        if (object == null || object instanceof DefaultMedium) {
            return (DefaultMedium)object;
        }
        return new DefaultMedium(object);
    }

    @Override
    @XmlElement(name="name", namespace="http://www.isotc211.org/2005/gmd")
    public MediumName getName() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.name : null;
    }

    public void setName(MediumName newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @XmlElement(name="density")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @UML(identifier="density", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getDensity() {
        return LegacyPropertyAdapter.getSingleton(this.densities, Double.class, null, DefaultMedium.class, "getDensity");
    }

    public void setDensity(Double newValue) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.densities));
        if (ImplementationHelper.ensurePositive(DefaultMedium.class, "density", true, newValue)) {
            this.densities = this.writeCollection(CollectionsExt.singletonOrEmpty(newValue), this.densities, Double.class);
        }
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getDensity"})
    @XmlElement(name="density", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Double> getDensities() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        this.densities = this.nonNullCollection(this.densities, Double.class);
        return this.densities;
    }

    @Deprecated(since="1.0")
    public void setDensities(Collection<? extends Double> newValues) {
        this.densities = this.writeCollection(newValues, this.densities, Double.class);
    }

    @Override
    @XmlElement(name="densityUnits")
    public Unit<?> getDensityUnits() {
        return this.densityUnits;
    }

    public void setDensityUnits(Unit<?> newValue) {
        this.checkWritePermission(this.densityUnits);
        this.densityUnits = newValue;
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="volumes")
    public Integer getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Integer newValue) {
        this.checkWritePermission(this.volumes);
        if (ImplementationHelper.ensurePositive(DefaultMedium.class, "volumes", false, newValue)) {
            this.volumes = newValue;
        }
    }

    @Override
    @XmlElement(name="mediumFormat")
    public Collection<MediumFormat> getMediumFormats() {
        this.mediumFormats = this.nonNullCollection(this.mediumFormats, MediumFormat.class);
        return this.mediumFormats;
    }

    public void setMediumFormats(Collection<? extends MediumFormat> newValues) {
        this.mediumFormats = this.writeCollection(newValues, this.mediumFormats, MediumFormat.class);
    }

    @Override
    @XmlElement(name="mediumNote")
    public InternationalString getMediumNote() {
        return this.mediumNote;
    }

    public void setMediumNote(InternationalString newValue) {
        this.checkWritePermission(this.mediumNote);
        this.mediumNote = newValue;
    }

    @Override
    @XmlElement(name="identifier")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    @UML(identifier="identifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier newValue) {
        super.setIdentifier(newValue);
    }

    @XmlElement(name="name")
    @XmlJavaTypeAdapter(value=CI_Citation.Since2014.class)
    private Citation getNewName() {
        return this.name != null ? new DefaultCitation(this.name.name()) : null;
    }

    private void setNewName(Citation newValue) {
        InternationalString title;
        if (newValue != null && (title = newValue.getTitle()) != null) {
            this.name = CodeLists.forName(MediumName.class, title.toString(), false);
        }
    }
}

