/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.logging;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.logging.NoOpLogger;
import org.apache.poi.util.ExceptionUtil;
import org.apache.poi.util.SuppressForbidden;

public final class PoiLogManager {
    private static final long SLEEP_TIME = 600000L;
    private static long LAST_TIME = 0L;

    private PoiLogManager() {
    }

    @SuppressForbidden(value="printStackTrace")
    public static Logger getLogger(Class<?> clz) {
        try {
            Logger logger = LogManager.getLogger(clz);
            if (logger == null) {
                if (PoiLogManager.shouldLog()) {
                    System.err.println("[PoiLogManager] Log4J returned null logger. Falling back to No-Op logger.");
                }
                return NoOpLogger.INSTANCE;
            }
            return logger;
        }
        catch (Throwable t) {
            if (!ExceptionUtil.isFatal(t) && PoiLogManager.shouldLog()) {
                System.err.println("[PoiLogManager] Issue loading Log4J. Falling back to No-Op logger.");
                t.printStackTrace();
            }
            return NoOpLogger.INSTANCE;
        }
    }

    @SuppressForbidden(value="printStackTrace")
    public static Logger getLogger(String name) {
        try {
            Logger logger = LogManager.getLogger(name);
            if (logger == null) {
                if (PoiLogManager.shouldLog()) {
                    System.err.println("[PoiLogManager] Log4J returned null logger. Falling back to No-Op logger.");
                }
                return NoOpLogger.INSTANCE;
            }
            return logger;
        }
        catch (Throwable t) {
            if (!ExceptionUtil.isFatal(t) && PoiLogManager.shouldLog()) {
                System.err.println("[PoiLogManager] Issue loading Log4J. Falling back to No-Op logger.");
                t.printStackTrace();
            }
            return NoOpLogger.INSTANCE;
        }
    }

    private static synchronized boolean shouldLog() {
        long time = System.currentTimeMillis();
        if (time > LAST_TIME + 600000L) {
            LAST_TIME = time;
            return true;
        }
        return false;
    }
}

