/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.spark.SparkException$;
import org.apache.spark.TaskContext$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfo;
import org.apache.spark.storage.BlockInfo$;
import org.apache.spark.storage.BlockInfoManager$;
import org.apache.spark.storage.BlockInfoWrapper;
import org.apache.spark.storage.RDDBlockId;
import org.slf4j.Logger;
import org.sparkproject.guava.collect.ConcurrentHashMultiset;
import org.sparkproject.guava.collect.ImmutableMultiset;
import org.sparkproject.guava.collect.Multiset;
import org.sparkproject.guava.util.concurrent.Striped;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tUb!B\u0013'\u0001\u0019r\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\u0001\u0003A\u0011A!\u0006\t\u0015\u0003AA\u0012\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002&\t\ri\u0003\u0001\u0015!\u0003\\\u0011\u00191\u0007\u0001)A\u0005O\"1\u0001\u0010\u0001Q\u0001\neD\u0001\"!\u0001\u0001A\u0003%\u00111\u0001\u0005\t\u0003#\u0001A\u0011\u0001\u0014\u0002\u0014!A\u0011\u0011\u0004\u0001\u0005\u0002!\nY\u0002\u0003\u0005\u0002 \u0001!\t\u0001KA\u0011\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\r\u0001\t\u0013\t)\u0004C\u0004\u00028\u0001!I!!\u000f\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005\"CAH\u0001E\u0005I\u0011AAI\u0011\u001d\t9\u000b\u0001C\u0001\u0003SC\u0011\"a,\u0001#\u0003%\t!!%\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"A\u0011q\u0017\u0001\u0005\u0002\u0019\nI\fC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\"I\u0011q\u001a\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001b\u0005\b\u0003+\u0004A\u0011AAl\u0011\u001d\ty\u000e\u0001C\u0001\u0003CD\u0001\"!@\u0001\t\u00031\u0013q \u0005\b\u0005\u0013\u0001A\u0011\u0001B\u0006\u0011!\u0011i\u0001\u0001C\u0001M\t=\u0001b\u0002B\t\u0001\u0011\u0005!1\u0003\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u00119\u0003\u0001C\u0001\u0005S9!Ba\u000b'\u0003\u0003E\tA\nB\u0017\r%)c%!A\t\u0002\u0019\u0012y\u0003\u0003\u0004AE\u0011\u0005!\u0011\u0007\u0005\n\u0005g\u0011\u0013\u0013!C\u0001\u0003#\u0013\u0001C\u00117pG.LeNZ8NC:\fw-\u001a:\u000b\u0005\u001dB\u0013aB:u_J\fw-\u001a\u0006\u0003S)\nQa\u001d9be.T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sON\u0019\u0001aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g!\t1\u0014(D\u00018\u0015\tA\u0004&\u0001\u0005j]R,'O\\1m\u0013\tQtGA\u0004M_\u001e<\u0017N\\4\u0002/Q\u0014\u0018mY6j]\u001e\u001c\u0015m\u00195f-&\u001c\u0018NY5mSRL8\u0001\u0001\t\u0003ayJ!aP\u0019\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\"A\u0011#\u0011\u0005\r\u0003Q\"\u0001\u0014\t\u000fm\u0012\u0001\u0013!a\u0001{\tiA+Y:l\u0003R$X-\u001c9u\u0013\u0012\u0004\"\u0001M$\n\u0005!\u000b$\u0001\u0002'p]\u001e\f\u0011C\u00197pG.LeNZ8Xe\u0006\u0004\b/\u001a:t!\u0011Y%\u000bV,\u000e\u00031S!!\u0014(\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002P!\u0006!Q\u000f^5m\u0015\u0005\t\u0016\u0001\u00026bm\u0006L!a\u0015'\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002D+&\u0011aK\n\u0002\b\u00052|7m[%e!\t\u0019\u0005,\u0003\u0002ZM\t\u0001\"\t\\8dW&sgm\\,sCB\u0004XM]\u0001\u0013S:4\u0018n]5cY\u0016\u0014F\t\u0012\"m_\u000e\\7\u000fE\u0002]C\u000el\u0011!\u0018\u0006\u0003=~\u000bq!\\;uC\ndWM\u0003\u0002ac\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\tl&a\u0002%bg\"\u001cV\r\u001e\t\u0003\u0007\u0012L!!\u001a\u0014\u0003\u0015I#EI\u00117pG.LE-A\u0003m_\u000e\\7\u000fE\u0002icNl\u0011!\u001b\u0006\u0003\u001b*T!aT6\u000b\u00051l\u0017AB2p[6|gN\u0003\u0002o_\u00061qm\\8hY\u0016T\u0011\u0001]\u0001\u0004G>l\u0017B\u0001:j\u0005\u001d\u0019FO]5qK\u0012\u0004\"\u0001\u001e<\u000e\u0003UT!A\u001a'\n\u0005],(\u0001\u0002'pG.\f\u0001c\u001e:ji\u0016dunY6t\u0005f$\u0016m]6\u0011\t-\u0013&\u0010 \t\u0003w\u000ei\u0011\u0001\u0001\t\u0004{z$V\"\u0001(\n\u0005}t%aA*fi\u0006y!/Z1e\u0019>\u001c7n\u001d\"z)\u0006\u001c8\u000eE\u0003L%j\f)\u0001E\u0003\u0002\b\u00055A+\u0004\u0002\u0002\n)\u0019\u00111B6\u0002\u000f\r|G\u000e\\3di&!\u0011qBA\u0005\u0005Y\u0019uN\\2veJ,g\u000e\u001e%bg\"lU\u000f\u001c;jg\u0016$\u0018!G2p]R\f\u0017N\\:J]ZL7/\u001b2mKJ#EI\u00117pG.$2!PA\u000b\u0011\u0019\t9\"\u0003a\u0001G\u00069!\r\\8dW&#\u0017!E5t%\u0012#%\t\\8dWZK7/\u001b2mKR\u0019Q(!\b\t\r\u0005]!\u00021\u0001d\u0003U!(/_'be.\u0014En\\2l\u0003N4\u0016n]5cY\u0016$B!a\t\u0002*A\u0019\u0001'!\n\n\u0007\u0005\u001d\u0012G\u0001\u0003V]&$\bBBA\f\u0017\u0001\u00071-\u0001\u0007sK\u001eL7\u000f^3s)\u0006\u001c8\u000e\u0006\u0003\u0002$\u0005=\u0002BBA\u0019\u0019\u0001\u0007!0A\u0007uCN\\\u0017\t\u001e;f[B$\u0018\nZ\u0001\u0015GV\u0014(/\u001a8u)\u0006\u001c8.\u0011;uK6\u0004H/\u00133\u0016\u0003i\f1\"Y2rk&\u0014X\rT8dWR1\u00111HA*\u0003+\"B!!\u0010\u0002JA)\u0001'a\u0010\u0002D%\u0019\u0011\u0011I\u0019\u0003\r=\u0003H/[8o!\r\u0019\u0015QI\u0005\u0004\u0003\u000f2#!\u0003\"m_\u000e\\\u0017J\u001c4p\u0011\u001d\tYE\u0004a\u0001\u0003\u001b\n\u0011A\u001a\t\u0007a\u0005=\u00131I\u001f\n\u0007\u0005E\u0013GA\u0005Gk:\u001cG/[8oc!1\u0011q\u0003\bA\u0002QCa!a\u0016\u000f\u0001\u0004i\u0014\u0001\u00032m_\u000e\\\u0017N\\4\u0002\u0013\tdwnY6J]\u001a|W\u0003BA/\u0003K\"B!a\u0018\u0002\u0006R!\u0011\u0011MA<!\u0011\t\u0019'!\u001a\r\u0001\u00119\u0011qM\bC\u0002\u0005%$!\u0001+\u0012\t\u0005-\u0014\u0011\u000f\t\u0004a\u00055\u0014bAA8c\t9aj\u001c;iS:<\u0007c\u0001\u0019\u0002t%\u0019\u0011QO\u0019\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002L=\u0001\r!!\u001f\u0011\u0013A\nY(a\u0011\u0002\u0000\u0005\u0005\u0014bAA?c\tIa)\u001e8di&|gN\r\t\u0004i\u0006\u0005\u0015bAABk\nI1i\u001c8eSRLwN\u001c\u0005\u0007\u0003/y\u0001\u0019\u0001+\u0002\u001d1|7m\u001b$peJ+\u0017\rZ5oOR1\u0011QHAF\u0003\u001bCa!a\u0006\u0011\u0001\u0004!\u0006\u0002CA,!A\u0005\t\u0019A\u001f\u000211|7m\u001b$peJ+\u0017\rZ5oO\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0014*\u001aQ(!&,\u0005\u0005]\u0005\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!)2\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\u000bYJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0002\\8dW\u001a{'o\u0016:ji&tw\r\u0006\u0004\u0002>\u0005-\u0016Q\u0016\u0005\u0007\u0003/\u0011\u0002\u0019\u0001+\t\u0011\u0005]#\u0003%AA\u0002u\n\u0001\u0004\\8dW\u001a{'o\u0016:ji&tw\r\n3fM\u0006,H\u000e\u001e\u00133\u0003u\t7o]3si\ncwnY6Jg2{7m[3e\r>\u0014xK]5uS:<G\u0003BA\"\u0003kCa!a\u0006\u0015\u0001\u0004!\u0016aA4fiR!\u0011QHA^\u0011\u0019\t9\"\u0006a\u0001)\u0006iAm\\<oOJ\fG-\u001a'pG.$B!a\t\u0002B\"1\u0011q\u0003\fA\u0002Q\u000ba!\u001e8m_\u000e\\GCBA\u0012\u0003\u000f\fI\r\u0003\u0004\u0002\u0018]\u0001\r\u0001\u0016\u0005\n\u0003\u0017<\u0002\u0013!a\u0001\u0003\u001b\f1\u0003^1tW\u0006#H/Z7qi&#w\n\u001d;j_:\u0004B\u0001MA u\u0006\u0001RO\u001c7pG.$C-\u001a4bk2$HEM\u000b\u0003\u0003'TC!!4\u0002\u0016\u00061Bn\\2l\u001d\u0016<(\t\\8dW\u001a{'o\u0016:ji&tw\rF\u0003>\u00033\fY\u000e\u0003\u0004\u0002\u0018e\u0001\r\u0001\u0016\u0005\b\u0003;L\u0002\u0019AA\"\u00031qWm\u001e\"m_\u000e\\\u0017J\u001c4p\u0003Y\u0011X\r\\3bg\u0016\fE\u000e\u001c'pG.\u001chi\u001c:UCN\\G\u0003BAr\u0003w\u0004R!!:\u0002vRsA!a:\u0002r:!\u0011\u0011^Ax\u001b\t\tYOC\u0002\u0002nr\na\u0001\u0010:p_Rt\u0014\"\u0001\u001a\n\u0007\u0005M\u0018'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0018\u0011 \u0002\u0004'\u0016\f(bAAzc!1\u0011\u0011\u0007\u000eA\u0002i\f\u0001cZ3u)\u0006\u001c8\u000eT8dW\u000e{WO\u001c;\u0015\t\t\u0005!q\u0001\t\u0004a\t\r\u0011b\u0001B\u0003c\t\u0019\u0011J\u001c;\t\r\u0005E2\u00041\u0001{\u0003\u0011\u0019\u0018N_3\u0016\u0005\t\u0005\u0011!F4fi:+XNY3s\u001f\u001al\u0015\r]#oiJLWm]\u000b\u0002\r\u00069QM\u001c;sS\u0016\u001cXC\u0001B\u000b!\u0019\t)Oa\u0006\u0003\u001c%!!\u0011DA}\u0005!IE/\u001a:bi>\u0014\bC\u0002\u0019\u0003\u001eQ\u000b\u0019%C\u0002\u0003 E\u0012a\u0001V;qY\u0016\u0014\u0014a\u0003:f[>4XM\u00117pG.$B!a\t\u0003&!1\u0011qC\u0010A\u0002Q\u000bQa\u00197fCJ$\"!a\t\u0002!\tcwnY6J]\u001a|W*\u00198bO\u0016\u0014\bCA\"#'\t\u0011s\u0006\u0006\u0002\u0003.\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002")
public class BlockInfoManager
implements Logging {
    private final boolean trackingCacheVisibility;
    private final ConcurrentHashMap<BlockId, BlockInfoWrapper> blockInfoWrappers;
    private final HashSet<RDDBlockId> invisibleRDDBlocks;
    private final Striped<Lock> locks;
    private final ConcurrentHashMap<Object, Set<BlockId>> writeLocksByTask;
    private final ConcurrentHashMap<Object, ConcurrentHashMultiset<BlockId>> readLocksByTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$1() {
        return BlockInfoManager$.MODULE$.$lessinit$greater$default$1();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean containsInvisibleRDDBlock(RDDBlockId blockId) {
        boolean bl;
        HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
        synchronized (hashSet) {
            bl = this.invisibleRDDBlocks.contains((Object)blockId);
        }
        return bl;
    }

    public boolean isRDDBlockVisible(RDDBlockId blockId) {
        if (this.trackingCacheVisibility) {
            boolean bl;
            HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
            synchronized (hashSet) {
                bl = this.blockInfoWrappers.containsKey(blockId) && !this.invisibleRDDBlocks.contains((Object)blockId);
            }
            return bl;
        }
        return true;
    }

    public void tryMarkBlockAsVisible(RDDBlockId blockId) {
        if (this.trackingCacheVisibility) {
            HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
            synchronized (hashSet) {
                this.invisibleRDDBlocks.remove((Object)blockId);
            }
            return;
        }
    }

    public void registerTask(long taskAttemptId) {
        this.writeLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), Collections.synchronizedSet(new java.util.HashSet()));
        this.readLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), (ConcurrentHashMultiset<BlockId>)ConcurrentHashMultiset.create());
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BlockInfo$.MODULE$.NON_TASK_WRITER()));
    }

    private Option<BlockInfo> acquireLock(BlockId blockId, boolean blocking, Function1<BlockInfo, Object> f) {
        BooleanRef done = BooleanRef.create((boolean)false);
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        while (!done.elem) {
            Object object;
            BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
            if (wrapper == null) {
                done.elem = true;
                object = BoxedUnit.UNIT;
                continue;
            }
            object = wrapper.withLock((Function2 & Serializable & scala.Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$acquireLock$1(f, result, done, blocking, info, condition);
                return BoxedUnit.UNIT;
            });
        }
        return (Option)result.elem;
    }

    private <T> T blockInfo(BlockId blockId, Function2<BlockInfo, Condition, T> f) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        if (wrapper == null) {
            throw SparkCoreErrors$.MODULE$.blockDoesNotExistError(blockId);
        }
        return wrapper.withLock(f);
    }

    public Option<BlockInfo> lockForReading(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Task ").append(taskAttemptId).append(" trying to acquire read lock for ").append(blockId).toString());
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForReading$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForReading$default$2() {
        return true;
    }

    public Option<BlockInfo> lockForWriting(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Task ").append(taskAttemptId).append(" trying to acquire write lock for ").append(blockId).toString());
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForWriting$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForWriting$default$2() {
        return true;
    }

    public BlockInfo assertBlockIsLockedForWriting(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        return (BlockInfo)this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, x$2) -> {
            if (info.writerTask() != taskAttemptId) {
                throw SparkCoreErrors$.MODULE$.taskHasNotLockedBlockError(this.currentTaskAttemptId(), blockId);
            }
            return info;
        });
    }

    public Option<BlockInfo> get(BlockId blockId) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        if (wrapper != null) {
            return new Some((Object)wrapper.info());
        }
        return None$.MODULE$;
    }

    public void downgradeLock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Task ").append(taskAttemptId).append(" downgrading write lock for ").append(blockId).toString());
        this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, x$3) -> {
            BlockInfoManager.$anonfun$downgradeLock$2(this, taskAttemptId, blockId, info, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void unlock(BlockId blockId, Option<Object> taskAttemptIdOption) {
        long taskAttemptId = BoxesRunTime.unboxToLong((Object)taskAttemptIdOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.currentTaskAttemptId()));
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Task ").append(taskAttemptId).append(" releasing lock for ").append(blockId).toString());
        this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$unlock$3(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> unlock$default$2() {
        return None$.MODULE$;
    }

    public boolean lockNewBlockForWriting(BlockId blockId, BlockInfo newBlockInfo) {
        boolean bl;
        block10: {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Task ").append(this.currentTaskAttemptId()).append(" trying to put ").append(blockId).toString());
            Lock lock = (Lock)this.locks.get((Object)blockId);
            lock.lock();
            try {
                BlockInfoWrapper wrapper = new BlockInfoWrapper(newBlockInfo, lock);
                do {
                    BlockInfoWrapper previous;
                    BlockInfoWrapper blockInfoWrapper;
                    if (this.trackingCacheVisibility) {
                        HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
                        synchronized (hashSet) {
                            BlockInfoWrapper res = this.blockInfoWrappers.putIfAbsent(blockId, wrapper);
                            if (res == null) {
                                blockId.asRDDId().foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)this.invisibleRDDBlocks.add((Object)elem)));
                            }
                            BlockInfoWrapper blockInfoWrapper2 = res;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6, 9] lbl15 : MonitorExitStatement: MONITOREXIT : var6_6
                            blockInfoWrapper = blockInfoWrapper2;
                        }
                    } else {
                        blockInfoWrapper = this.blockInfoWrappers.putIfAbsent(blockId, wrapper);
                    }
                    if ((previous = blockInfoWrapper) != null) continue;
                    Option<BlockInfo> result = this.lockForWriting(blockId, false);
                    Predef$.MODULE$.assert(result.isDefined());
                    bl = true;
                    break block10;
                } while (!this.lockForReading(blockId, this.lockForReading$default$2()).isDefined());
                bl = false;
            }
            finally {
                lock.unlock();
            }
        }
        return bl;
    }

    public Seq<BlockId> releaseAllLocksForTask(long taskAttemptId) {
        ArrayBuffer blocksWithReleasedLocks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set writeLocks = (Set)Option$.MODULE$.apply(this.writeLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptySet());
        writeLocks.forEach(blockId -> {
            this.blockInfo((BlockId)blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$3(taskAttemptId, info, condition);
                return BoxedUnit.UNIT;
            });
            blocksWithReleasedLocks.$plus$eq(blockId);
        });
        Multiset readLocks = (Multiset)Option$.MODULE$.apply(this.readLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableMultiset.of());
        readLocks.entrySet().forEach(entry -> {
            BlockId blockId = (BlockId)entry.getElement();
            int lockCount = entry.getCount();
            blocksWithReleasedLocks.$plus$eq((Object)blockId);
            this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$6(lockCount, info, condition);
                return BoxedUnit.UNIT;
            });
        });
        return blocksWithReleasedLocks.toSeq();
    }

    public int getTaskLockCount(long taskAttemptId) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public int size() {
        return this.blockInfoWrappers.size();
    }

    public long getNumberOfMapEntries() {
        return this.size() + this.readLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.readLocksByTask).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$1(x$6)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.writeLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.writeLocksByTask).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$2(x$7)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Iterator<Tuple2<BlockId, BlockInfo>> entries() {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.blockInfoWrappers.entrySet().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv.getKey()), (Object)((BlockInfoWrapper)kv.getValue()).info()));
    }

    public void removeBlock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(taskAttemptId).append(" trying to remove block ").append(blockId).toString());
        this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$removeBlock$2(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.blockInfoWrappers.values().forEach(wrapper -> wrapper.tryLock((Function2<BlockInfo, Condition, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$clear$2(info, condition);
            return BoxedUnit.UNIT;
        }));
        this.blockInfoWrappers.clear();
        this.readLocksByTask.clear();
        this.writeLocksByTask.clear();
        HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
        synchronized (hashSet) {
            this.invisibleRDDBlocks.clear();
        }
    }

    public static final /* synthetic */ void $anonfun$acquireLock$1(Function1 f$1, ObjectRef result$1, BooleanRef done$1, boolean blocking$1, BlockInfo info, Condition condition) {
        if (BoxesRunTime.unboxToBoolean((Object)f$1.apply((Object)info))) {
            result$1.elem = new Some((Object)info);
            done$1.elem = true;
            return;
        }
        if (!blocking$1) {
            done$1.elem = true;
            return;
        }
        condition.await();
    }

    public static final /* synthetic */ boolean $anonfun$lockForReading$2(BlockInfoManager $this, long taskAttemptId$1, BlockId blockId$1, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER();
            if (!acquire) break block0;
            info.readerCount_$eq(info.readerCount() + 1);
            $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$1)).add((Object)blockId$1);
            $this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(taskAttemptId$1).append(" acquired read lock for ").append(blockId$1).toString());
        }
        return acquire;
    }

    public static final /* synthetic */ boolean $anonfun$lockForWriting$2(BlockInfoManager $this, long taskAttemptId$2, BlockId blockId$2, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER() && info.readerCount() == 0;
            if (!acquire) break block0;
            info.writerTask_$eq(taskAttemptId$2);
            $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$2)).add(blockId$2);
            $this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Task ").append(taskAttemptId$2).append(" acquired write lock for ").append(blockId$2).toString());
        }
        return acquire;
    }

    public static final /* synthetic */ void $anonfun$downgradeLock$2(BlockInfoManager $this, long taskAttemptId$4, BlockId blockId$4, BlockInfo info, Condition x$3) {
        Predef$.MODULE$.require(info.writerTask() == taskAttemptId$4, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Task ").append(taskAttemptId$4).append(" tried to downgrade a write lock that it does not hold on").append(" block ").append(blockId$4).toString());
        $this.unlock(blockId$4, $this.unlock$default$2());
        Option<BlockInfo> lockOutcome = $this.lockForReading(blockId$4, false);
        Predef$.MODULE$.assert(lockOutcome.isDefined());
    }

    public static final /* synthetic */ void $anonfun$unlock$3(BlockInfoManager $this, long taskAttemptId$5, BlockId blockId$5, BlockInfo info, Condition condition) {
        Object object;
        if (info.writerTask() != BlockInfo$.MODULE$.NO_WRITER()) {
            info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
            object = BoxesRunTime.boxToBoolean((boolean)$this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5)).remove(blockId$5));
        } else {
            ConcurrentHashMultiset<BlockId> countsForTask = $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5));
            if (countsForTask != null) {
                Predef$.MODULE$.assert(info.readerCount() > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Block ").append(blockId$5).append(" is not locked for reading").toString());
                info.readerCount_$eq(info.readerCount() - 1);
                int newPinCountForTask = countsForTask.remove((Object)blockId$5, 1) - 1;
                Predef$.MODULE$.assert(newPinCountForTask >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Task ").append(taskAttemptId$5).append(" release lock on block ").append(blockId$5).append(" more times than it acquired it").toString());
            }
            object = BoxedUnit.UNIT;
        }
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$3(long taskAttemptId$6, BlockInfo info, Condition condition) {
        Predef$.MODULE$.assert(info.writerTask() == taskAttemptId$6);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$6(int lockCount$1, BlockInfo info, Condition condition) {
        info.readerCount_$eq(info.readerCount() - lockCount$1);
        Predef$.MODULE$.assert(info.readerCount() >= 0);
        condition.signalAll();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$1(Tuple2 x$6) {
        return ((ConcurrentHashMultiset)x$6._2()).size();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$2(Tuple2 x$7) {
        return ((Set)x$7._2()).size();
    }

    public static final /* synthetic */ void $anonfun$removeBlock$2(BlockInfoManager $this, long taskAttemptId$7, BlockId blockId$7, BlockInfo info, Condition condition) {
        if (info.writerTask() != taskAttemptId$7) {
            throw SparkException$.MODULE$.internalError(new StringBuilder(52).append("Task ").append(taskAttemptId$7).append(" called remove() on block ").append(blockId$7).append(" without a write lock").toString(), "STORAGE");
        }
        HashSet<RDDBlockId> hashSet = $this.invisibleRDDBlocks;
        synchronized (hashSet) {
            $this.blockInfoWrappers.remove(blockId$7);
            blockId$7.asRDDId().foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)$this.invisibleRDDBlocks.remove((Object)elem)));
        }
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$7)).remove(blockId$7);
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$clear$2(BlockInfo info, Condition condition) {
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        condition.signalAll();
    }

    public BlockInfoManager(boolean trackingCacheVisibility) {
        this.trackingCacheVisibility = trackingCacheVisibility;
        Logging.$init$((Logging)this);
        this.blockInfoWrappers = new ConcurrentHashMap();
        this.invisibleRDDBlocks = new HashSet();
        this.locks = Striped.lock((int)1024);
        this.writeLocksByTask = new ConcurrentHashMap();
        this.readLocksByTask = new ConcurrentHashMap();
        this.registerTask(BlockInfo$.MODULE$.NON_TASK_WRITER());
    }
}

