/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.util.List;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.lib.FrameLibCompress;
import org.apache.sysds.runtime.io.FrameWriterBinaryBlockParallel;
import org.apache.sysds.runtime.matrix.data.Pair;

public class FrameWriterCompressed
extends FrameWriterBinaryBlockParallel {
    private final boolean parallel;

    public FrameWriterCompressed(boolean parallel) {
        this.parallel = parallel;
    }

    @Override
    protected Pair<List<Pair<Integer, Array<?>>>, FrameBlock> extractDictionaries(FrameBlock src) {
        int k = this.parallel ? OptimizerUtils.getParallelBinaryWriteParallelism() : 1;
        FrameBlock compressed = FrameLibCompress.compress(src, k);
        return super.extractDictionaries(compressed);
    }
}

