/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.VirtualizableElementList;
import net.sf.jasperreports.engine.fill.OffsetElements;

public class OffsetElementsUtil {
    public static void transfer(List<Object> elements, Consumer<JRPrintElement> consumer) {
        elements.stream().forEach(item -> {
            if (item instanceof JRPrintElement) {
                consumer.accept((JRPrintElement)item);
            } else {
                OffsetElements offsetElements = (OffsetElements)item;
                Consumer<JRPrintElement> offsetElementConsumer = element -> {
                    element.setX(offsetElements.getOffsetX() + element.getX());
                    element.setY(offsetElements.getOffsetY() + element.getY());
                };
                offsetElementConsumer = offsetElementConsumer.andThen(consumer);
                Collection<? extends JRPrintElement> subElements = offsetElements.getElements();
                if (subElements instanceof VirtualizableElementList) {
                    ((VirtualizableElementList)subElements).transferElements(offsetElementConsumer);
                } else {
                    subElements.stream().forEach(offsetElementConsumer);
                    subElements.clear();
                }
            }
        });
    }
}

