/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.io.IOException;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class TableStyle
extends Style {
    private int width;
    private int pageFormatIndex;
    private boolean isFrame;
    private boolean isPageBreak;
    private Color tabColor;

    public TableStyle(WriterHelper styleWriter, int width, int pageFormatIndex, boolean isFrame, boolean isPageBreak, Color tabColor) {
        super(styleWriter);
        this.width = width;
        this.pageFormatIndex = pageFormatIndex;
        this.isFrame = isFrame;
        this.isPageBreak = isPageBreak;
        this.tabColor = tabColor;
    }

    @Override
    public String getId() {
        return "" + this.width + "|" + this.pageFormatIndex + "|" + this.isFrame + "|" + this.isPageBreak + "|" + this.tabColor;
    }

    @Override
    public void write(String tableStyleName) throws IOException {
        this.styleWriter.write(" <style:style style:name=\"" + tableStyleName + "\"");
        if (!this.isFrame) {
            this.styleWriter.write(" style:master-page-name=\"master_" + this.pageFormatIndex + "\"");
        }
        this.styleWriter.write(" style:family=\"table\">\n");
        this.styleWriter.write("   <style:table-properties");
        this.styleWriter.write(" table:align=\"left\" style:width=\"" + LengthUtil.inchFloor4Dec(this.width) + "in\"");
        if (this.isPageBreak) {
            this.styleWriter.write(" fo:break-before=\"page\"");
        }
        if (this.tabColor != null) {
            this.styleWriter.write(" tableooo:tab-color=\"#" + JRColorUtil.getColorHexa(this.tabColor) + "\"");
        }
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" </style:style>\n");
        this.styleWriter.flush();
    }
}

