/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;

public class NoMessage
extends Expression {
    private final Expression subexpression;

    public NoMessage(SourcePosition pos, String displayName, Expression subexpression) {
        super(pos, displayName, subexpression.getSchema());
        this.subexpression = Preconditions.checkNotNull(subexpression);
    }

    public NoMessage(Node fromNode, Expression subexpression) {
        super(fromNode, subexpression.getSchema());
        this.subexpression = Preconditions.checkNotNull(subexpression);
    }

    public Expression getSubexpression() {
        return this.subexpression;
    }

    public Expression withSubexpression(Expression newSubexpression) {
        return newSubexpression.equals(this.subexpression) ? this : new NoMessage((Node)this, newSubexpression);
    }

    @Override
    public boolean alwaysEmpty() {
        return this.subexpression.alwaysEmpty();
    }

    @Override
    public boolean alwaysOnlyWhitespace() {
        return this.subexpression.alwaysOnlyWhitespace();
    }

    @Override
    public boolean alwaysEquals(boolean value) {
        return this.subexpression.alwaysEquals(value);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitNoMessage(this);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof NoMessage && this.equals((NoMessage)that);
    }

    public boolean equals(NoMessage that) {
        return this.equalsExpression(that) && Objects.equal(this.getSubexpression(), that.getSubexpression());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getSubexpression());
    }
}

