/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AbstractNode;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.schema.Schema;
import java.util.List;

public class Conditional
extends Expression {
    private final ImmutableList<Clause> clauses;
    private final Expression elseExpression;

    public Conditional(Node fromNode, Schema schema, List<Clause> clauses, Expression elseExpression) {
        super(fromNode, schema);
        if (clauses.isEmpty()) {
            throw new IllegalArgumentException("At least one clause is required.");
        }
        if (schema != null) {
            for (Clause clause : clauses) {
                Schema clauseSchema = clause.getExpression().getSchema();
                if (schema.allows(clauseSchema)) continue;
                throw new IllegalArgumentException("Incompatible schemas: " + clauseSchema + " clause in " + schema + " conditional");
            }
            if (!Objects.equal(schema, elseExpression.getSchema())) {
                throw new IllegalArgumentException("Incompatible schemas: " + elseExpression.getSchema() + " else in " + schema + " conditional");
            }
        }
        this.clauses = ImmutableList.copyOf(clauses);
        this.elseExpression = Preconditions.checkNotNull(elseExpression);
    }

    public Conditional(Node fromNode, Schema schema, Expression predicate, Expression expression, Expression elseExpression) {
        this(fromNode, schema, Conditional.createClauses(fromNode, predicate, expression), elseExpression);
    }

    private static List<Clause> createClauses(Node fromNode, Expression predicate, Expression expression) {
        return ImmutableList.of(new Clause(fromNode, predicate, expression));
    }

    public Conditional withSchemaAndClauses(Schema newSchema, List<Clause> newClauses, Expression newElseExpression) {
        return Objects.equal(this.getSchema(), newSchema) && Iterables.elementsEqual(newClauses, this.clauses) && this.elseExpression.equals(newElseExpression) ? this : new Conditional(this, newSchema, newClauses, newElseExpression);
    }

    public List<Clause> getClauses() {
        return this.clauses;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    public Conditional withClauses(List<Clause> newClauses, Expression newElseExpression) {
        return Iterables.elementsEqual(newClauses, this.clauses) && this.elseExpression.equals(newElseExpression) ? this : new Conditional(this, this.getSchema(), newClauses, newElseExpression);
    }

    @Override
    public boolean alwaysEquals(Expression that) {
        if (!(that instanceof Conditional) || that.getSchema() == null || !that.getSchema().equals((Object)this.getSchema())) {
            return false;
        }
        Conditional thatConditional = (Conditional)that;
        List<Clause> hisClauses = thatConditional.getClauses();
        if (this.clauses.size() != hisClauses.size()) {
            return false;
        }
        for (int i = 0; i < this.clauses.size(); ++i) {
            if (((Clause)this.clauses.get(i)).alwaysEquals(hisClauses.get(i))) continue;
            return false;
        }
        return this.elseExpression.alwaysEquals(thatConditional.getElseExpression());
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitConditional(this);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof Conditional && this.equals((Conditional)that);
    }

    public boolean equals(Conditional that) {
        return this.equalsExpression(that) && Iterables.elementsEqual(this.clauses, that.clauses) && this.elseExpression.equals(that.elseExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.clauses, this.elseExpression);
    }

    public static class Clause
    extends AbstractNode {
        private final Expression predicate;
        private final Expression expression;

        public Clause(Node fromNode, Expression predicate, Expression expression) {
            this(fromNode.getSourcePosition(), fromNode.getDisplayName(), predicate, expression);
        }

        public Clause(SourcePosition sourcePosition, String displayName, Expression predicate, Expression expression) {
            super(sourcePosition, displayName);
            this.predicate = Preconditions.checkNotNull(predicate);
            this.expression = Preconditions.checkNotNull(expression);
        }

        public Expression getPredicate() {
            return this.predicate;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Clause withExpression(Expression newExpression) {
            return newExpression.equals(this.expression) ? this : new Clause(this, this.predicate, newExpression);
        }

        public boolean alwaysEquals(Clause that) {
            return this.predicate.alwaysEquals(that.predicate) && this.expression.alwaysEquals(that.expression);
        }

        public boolean equals(Object that) {
            return that instanceof Clause && this.equals((Clause)that);
        }

        public boolean equals(Clause that) {
            return this.equalsAbstractNode(that) && this.predicate.equals(that.predicate) && this.expression.equals(that.expression);
        }

        public int hashCode() {
            return Objects.hashCode(this.abstractNodeHashCode(), this.predicate, this.expression);
        }
    }
}

