/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.util.List;
import net.sf.oval.Validator;

public final class CollectionUtils {
    public static <T> List<T> clone(List<T> list) {
        List clone = Validator.getCollectionFactory().createList(list.size());
        clone.addAll(list);
        return clone;
    }

    public static <T> T getLast(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> T removeLast(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        int idx = list.size() - 1;
        return list.remove(idx);
    }

    public static <T> void removeLast(List<T> list, T expectedItem) {
        if (list.isEmpty()) {
            return;
        }
        int idx = list.size() - 1;
        T lastElement = list.remove(idx);
        if (lastElement != expectedItem) {
            throw new IllegalArgumentException("Last element [" + lastElement + "] is not expected: " + expectedItem);
        }
    }

    private CollectionUtils() {
    }
}

