/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.bundled;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Set;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaResponseWrapper;
import org.apache.sling.scripting.core.impl.ServiceCache;
import org.apache.sling.scripting.core.impl.bundled.ExecutableUnit;
import org.apache.sling.scripting.core.impl.bundled.ScriptContextProvider;
import org.apache.sling.scripting.spi.bundle.TypeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBundledRenderUnit
implements ExecutableUnit {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractBundledRenderUnit.class.getName());
    private final Set<TypeProvider> providers;
    private final Bundle bundle;
    private final BundleContext bundleContext;
    private final String path;
    private final String scriptEngineName;
    private final String scriptExtension;
    private final ScriptContextProvider scriptContextProvider;
    private final ServiceCache serviceCache;

    AbstractBundledRenderUnit(@NotNull Set<TypeProvider> providers, @NotNull BundleContext context, @NotNull Bundle bundle, @NotNull String path, @NotNull String scriptEngineName, @NotNull String scriptExtension, @NotNull ScriptContextProvider scriptContextProvider, @NotNull ServiceCache serviceCache) {
        this.providers = providers;
        this.bundle = bundle;
        this.path = path;
        this.scriptEngineName = scriptEngineName;
        this.scriptExtension = scriptExtension;
        this.scriptContextProvider = scriptContextProvider;
        this.bundleContext = context;
        this.serviceCache = serviceCache;
    }

    @NotNull
    public Bundle getBundle() {
        return this.bundle;
    }

    @NotNull
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @NotNull
    public Set<TypeProvider> getTypeProviders() {
        return this.providers;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    @Override
    @NotNull
    public String getScriptExtension() {
        return this.scriptExtension;
    }

    @Override
    @NotNull
    public ServiceCache getServiceCache() {
        return this.serviceCache;
    }

    @Nullable
    public <T> T getService(@NotNull String className) {
        try {
            ClassLoader bundleClassloader = ((BundleWiring)this.getBundle().adapt(BundleWiring.class)).getClassLoader();
            return (T)this.serviceCache.getService(bundleClassloader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to retrieve a service of type " + className + " for bundled script " + this.path, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public <T> T[] getServices(@NotNull String className, @Nullable String filter) {
        try {
            ClassLoader bundleClassloader = ((BundleWiring)this.getBundle().adapt(BundleWiring.class)).getClassLoader();
            return this.serviceCache.getServices(bundleClassloader.loadClass(className), filter);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to retrieve a service of type " + className + " for bundled script " + this.path, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(@NotNull HttpServletRequest request, @NotNull jakarta.servlet.http.HttpServletResponse response) throws ScriptException {
        try {
            ScriptContextProvider.ExecutableContext executableContext = this.scriptContextProvider.prepareScriptContext((SlingJakartaHttpServletRequest)request, (SlingJakartaHttpServletResponse)response, this);
            try {
                executableContext.eval();
            }
            finally {
                executableContext.clean();
            }
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
    }

    public void eval(@NotNull javax.servlet.http.HttpServletRequest request, @NotNull HttpServletResponse response) throws ScriptException {
        this.eval(JavaxToJakartaRequestWrapper.toJakartaRequest((javax.servlet.http.HttpServletRequest)request), JavaxToJakartaResponseWrapper.toJakartaResponse((HttpServletResponse)response));
    }
}

