/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.util;

import java.util.Map;
import org.ops4j.peaberry.Export;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.util.DelegatingImport;
import org.ops4j.peaberry.util.StaticImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleExport<T>
implements Export<T> {
    private Import<T> service;
    private Map<String, ?> attributes;

    public SimpleExport(Import<T> service) {
        this.service = new CountingImport<T>(service);
    }

    @Override
    public synchronized T get() {
        return this.service.get();
    }

    @Override
    public synchronized Map<String, ?> attributes() {
        return null == this.attributes ? this.service.attributes() : this.attributes;
    }

    @Override
    public synchronized void unget() {
        this.service.unget();
    }

    @Override
    public boolean available() {
        return this.service.available();
    }

    @Override
    public synchronized void put(T newInstance) {
        if (this.service instanceof CountingImport) {
            ((CountingImport)this.service).unwind();
        }
        this.service = new StaticImport<T>(newInstance, this.service.attributes());
    }

    @Override
    public synchronized void attributes(Map<String, ?> newAttributes) {
        this.attributes = newAttributes;
    }

    @Override
    public void unput() {
        this.put(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CountingImport<T>
    extends DelegatingImport<T> {
        private int count;

        CountingImport(Import<T> service) {
            super(service);
        }

        @Override
        public T get() {
            ++this.count;
            return super.get();
        }

        @Override
        public void unget() {
            --this.count;
            super.unget();
        }

        void unwind() {
            while (this.count-- > 0) {
                super.unget();
            }
        }
    }
}

