/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import com.google.common.eventbus.Subscribe;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.WatchedUpdateResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import org.apache.servicecomb.config.event.DynamicConfigurationChangedEvent;
import org.apache.servicecomb.config.event.RefreshGovernanceConfigurationEvent;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.apache.servicecomb.foundation.bootstrap.BootStrapService;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class ConfigurationSpringInitializer
extends PropertySourcesPlaceholderConfigurer
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSpringInitializer.class);
    public static final String EXTRA_CONFIG_SOURCE_PREFIX = "extraConfig-";
    public static final String MICROSERVICE_PROPERTY_SOURCE_NAME = "microservice.yaml";
    public static final String MAPPING_PROPERTY_SOURCE_NAME = "mapping.yaml";
    public static final String EXTERNAL_INIT = "scb-config-external-init";
    private final List<BootStrapService> bootStrapServices = SPIServiceUtils.getSortedService(BootStrapService.class);
    private final Map<String, Object> dynamicData = new ConcurrentHashMap<String, Object>();
    private ConfigCenterConfigurationSource configCenterConfigurationSource;

    public static void setExternalInit(boolean value) {
        System.setProperty(EXTERNAL_INIT, String.valueOf(value));
    }

    public static boolean isExternalInit() {
        return Boolean.getBoolean(EXTERNAL_INIT);
    }

    public ConfigurationSpringInitializer() {
        this.setOrder(0x3FFFFFFF);
        this.setIgnoreUnresolvablePlaceholders(true);
    }

    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        if (ConfigurationSpringInitializer.isExternalInit()) {
            return;
        }
        this.syncFromSpring(environment);
        ConfigurationSpringInitializer.syncToSpring(environment);
        this.startupBootStrapService(environment);
        EventManager.register((Object)((Object)this));
        this.configCenterConfigurationSource = ConfigUtil.installDynamicConfig();
        this.addDynamicConfigurationToSpring(environment, this.configCenterConfigurationSource);
    }

    @Subscribe
    public void onConfigurationDataChanged(DynamicConfigurationChangedEvent event) {
        try {
            WatchedUpdateResult data = event.getEvent();
            if (data.getDeleted() != null) {
                data.getDeleted().forEach((k, v) -> this.dynamicData.remove(k));
            }
            if (data.getAdded() != null) {
                this.dynamicData.putAll(data.getAdded());
            }
            if (data.getChanged() != null) {
                this.dynamicData.putAll(data.getChanged());
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        EventManager.post((Object)new RefreshGovernanceConfigurationEvent(event.getEvent()));
    }

    private void syncFromSpring(Environment environment) {
        String environmentName = this.generateNameForEnvironment(environment);
        LOGGER.info("Environment received, will get configurations from [{}].", (Object)environmentName);
        Map<String, Object> extraConfig = this.getAllProperties(environment);
        ConfigUtil.addExtraConfig((String)(EXTRA_CONFIG_SOURCE_PREFIX + environmentName), extraConfig);
    }

    public static void syncToSpring(Environment environment) {
        if (ConfigurationSpringInitializer.isExternalInit()) {
            return;
        }
        ConfigurationSpringInitializer.addMicroserviceYAMLToSpring(environment);
        ConfigurationSpringInitializer.addMappingToSpring(environment);
    }

    private void startupBootStrapService(Environment environment) {
        this.bootStrapServices.forEach(bootStrapService -> bootStrapService.startup(environment));
    }

    private static void addMicroserviceYAMLToSpring(final Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return;
        }
        MutablePropertySources propertySources = ((ConfigurableEnvironment)environment).getPropertySources();
        if (propertySources.contains(MICROSERVICE_PROPERTY_SOURCE_NAME)) {
            return;
        }
        propertySources.addLast((PropertySource)new EnumerablePropertySource<MicroserviceConfigLoader>(MICROSERVICE_PROPERTY_SOURCE_NAME){
            private final Map<String, Object> values;
            private final String[] propertyNames;
            {
                super(name);
                this.values = new HashMap<String, Object>();
                MicroserviceConfigLoader loader = new MicroserviceConfigLoader();
                loader.loadAndSort();
                loader.getConfigModels().forEach(configModel -> this.values.putAll(YAMLUtil.retrieveItems((String)"", (Map)configModel.getConfig())));
                this.propertyNames = this.values.keySet().toArray(new String[0]);
            }

            public String[] getPropertyNames() {
                return this.propertyNames;
            }

            public Object getProperty(String name) {
                List value = this.values.get(name);
                if (value instanceof List) {
                    value = ((List)value).stream().filter(item -> item instanceof String).map(item -> environment.resolvePlaceholders((String)item)).collect(Collectors.toList());
                }
                return value;
            }
        });
    }

    private static void addMappingToSpring(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return;
        }
        MutablePropertySources propertySources = ((ConfigurableEnvironment)environment).getPropertySources();
        if (propertySources.contains(MAPPING_PROPERTY_SOURCE_NAME)) {
            return;
        }
        Map mappings = ConfigMapping.getConvertedMap((Environment)environment);
        propertySources.addFirst((PropertySource)new MapPropertySource(MAPPING_PROPERTY_SOURCE_NAME, mappings));
    }

    private void addDynamicConfigurationToSpring(Environment environment, ConfigCenterConfigurationSource configCenterConfigurationSource) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return;
        }
        ConfigurableEnvironment ce = (ConfigurableEnvironment)environment;
        if (configCenterConfigurationSource == null) {
            return;
        }
        try {
            ce.getPropertySources().addFirst((PropertySource)new MapPropertySource("dynamic-source", this.dynamicData));
        }
        catch (Exception e) {
            if (DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.error.printSensitiveErrorMessage", false).get()) {
                LOGGER.warn("set up spring property source failed.", (Throwable)e);
            }
            LOGGER.warn("set up spring property source failed. msg: {}", (Object)e.getMessage());
        }
    }

    protected Properties mergeProperties() throws IOException {
        Properties properties = super.mergeProperties();
        if (ConfigurationSpringInitializer.isExternalInit()) {
            return properties;
        }
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        Iterator iterator = config.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = config.getProperty(key);
            properties.put(key, value);
        }
        return properties;
    }

    private String generateNameForEnvironment(Environment environment) {
        String environmentName = environment.getProperty("spring.config.name");
        if (!StringUtils.isEmpty((CharSequence)environmentName)) {
            return environmentName;
        }
        environmentName = environment.getProperty("spring.application.name");
        if (!StringUtils.isEmpty((CharSequence)environmentName)) {
            return environmentName;
        }
        return environment.getClass().getName() + "@" + environment.hashCode();
    }

    private Map<String, Object> getAllProperties(Environment environment) {
        HashMap<String, Object> configFromSpringBoot = new HashMap<String, Object>();
        if (!(environment instanceof ConfigurableEnvironment)) {
            return configFromSpringBoot;
        }
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
        if (this.ignoreResolveFailure()) {
            configurableEnvironment.setIgnoreUnresolvableNestedPlaceholders(true);
        }
        for (PropertySource propertySource : configurableEnvironment.getPropertySources()) {
            if (MICROSERVICE_PROPERTY_SOURCE_NAME.equals(propertySource.getName()) || MAPPING_PROPERTY_SOURCE_NAME.equals(propertySource.getName())) continue;
            this.getProperties(configurableEnvironment, propertySource, configFromSpringBoot);
        }
        return configFromSpringBoot;
    }

    private void getProperties(ConfigurableEnvironment environment, PropertySource<?> propertySource, Map<String, Object> configFromSpringBoot) {
        if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource compositePropertySource = (CompositePropertySource)propertySource;
            compositePropertySource.getPropertySources().forEach(ps -> this.getProperties(environment, (PropertySource<?>)ps, configFromSpringBoot));
            return;
        }
        if (propertySource instanceof EnumerablePropertySource) {
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                try {
                    Object propertyValue = environment.getProperty(propertyName, Object.class);
                    if (propertyValue == null) {
                        LOGGER.error("The value of a configuration item is null, please check whether there is any impact, config item key: {}", (Object)propertyName);
                        continue;
                    }
                    configFromSpringBoot.put(propertyName, propertyValue);
                }
                catch (Exception e) {
                    throw new RuntimeException("set up spring property source failed.If you still want to start up the application and ignore errors, you can set servicecomb.config.ignoreResolveFailure to true.", e);
                }
            }
            return;
        }
        LOGGER.debug("a none EnumerablePropertySource is ignored, propertySourceName = [{}]", (Object)propertySource.getName());
    }

    private boolean ignoreResolveFailure() {
        return ConfigUtil.createLocalConfig().getBoolean("servicecomb.config.ignoreResolveFailure", false);
    }
}

