/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Map;
import org.apache.servicecomb.registry.config.ConfigurePropertyUtils;

public final class Configuration {
    public static final String ROOT = "servicecomb.loadbalance.";
    public static final String SERVER_EXPIRED_IN_SECONDS = "servicecomb.loadbalance.stats.serverExpiredInSeconds";
    public static final String TIMER_INTERVAL_IN_MILLIS = "servicecomb.loadbalance.stats.timerIntervalInMillis";
    public static final String RULE_STRATEGY_NAME = "strategy.name";
    public static final String ROOT_20 = "ribbon.";
    public static final String RETRY_HANDLER = "retryHandler";
    public static final String SESSION_TIMEOUT_IN_SECONDS = "SessionStickinessRule.sessionTimeoutInSeconds";
    public static final String SUCCESSIVE_FAILED_TIMES = "SessionStickinessRule.successiveFailedTimes";
    private static final double PERCENT = 100.0;
    public static final String FILTER_ISOLATION = "isolation.";
    public static final String FILTER_OPEN = "enabled";
    public static final String FILTER_ERROR_PERCENTAGE = "errorThresholdPercentage";
    public static final String FILTER_ENABLE_REQUEST = "enableRequestThreshold";
    public static final String FILTER_RECOVER_IMMEDIATELY_WHEN_SUCCESS = "recoverImmediatelyWhenSuccess";
    public static final String FILTER_SINGLE_TEST = "singleTestTime";
    public static final String FILTER_MAX_SINGLE_TEST_WINDOW = "maxSingleTestWindow";
    public static final String FILTER_MIN_ISOLATION_TIME = "minIsolationTime";
    public static final String FILTER_CONTINUOUS_FAILURE_THRESHOLD = "continuousFailureThreshold";
    public static final String TRANSACTIONCONTROL_OPTIONS_PREFIX_PATTERN = "servicecomb.loadbalance.%s.transactionControl.options";
    public static final Configuration INSTANCE = new Configuration();

    private Configuration() {
    }

    public String getRuleStrategyName(String microservice) {
        return Configuration.getStringProperty(null, ROOT + microservice + ".strategy.name", "servicecomb.loadbalance.strategy.name");
    }

    public int getSessionTimeoutInSeconds(String microservice) {
        int defaultValue = 30;
        String p = Configuration.getStringProperty("30", ROOT + microservice + ".SessionStickinessRule.sessionTimeoutInSeconds", "servicecomb.loadbalance.SessionStickinessRule.sessionTimeoutInSeconds");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 30;
        }
    }

    public int getSuccessiveFailedTimes(String microservice) {
        int defaultValue = 5;
        String p = Configuration.getStringProperty("5", ROOT + microservice + ".SessionStickinessRule.successiveFailedTimes", "servicecomb.loadbalance.SessionStickinessRule.successiveFailedTimes");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public boolean isIsolationFilterOpen(String microservice) {
        String p = Configuration.getStringProperty("true", ROOT + microservice + ".isolation.enabled", "servicecomb.loadbalance.isolation.enabled");
        return Boolean.parseBoolean(p);
    }

    public int getErrorThresholdPercentage(String microservice) {
        boolean defaultValue = false;
        String p = Configuration.getStringProperty("0", ROOT + microservice + ".isolation.errorThresholdPercentage", "servicecomb.loadbalance.isolation.errorThresholdPercentage");
        try {
            int result = Integer.parseInt(p);
            if ((double)result <= 100.0 && result > 0) {
                return result;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getEnableRequestThreshold(String microservice) {
        return this.getThreshold(microservice, FILTER_ENABLE_REQUEST);
    }

    public int getSingleTestTime(String microservice) {
        int defaultValue = 60000;
        String p = Configuration.getStringProperty("60000", ROOT + microservice + ".isolation.singleTestTime", "servicecomb.loadbalance.isolation.singleTestTime");
        try {
            int result = Integer.parseInt(p);
            if (result >= 0) {
                return result;
            }
            return 60000;
        }
        catch (NumberFormatException e) {
            return 60000;
        }
    }

    public int getMaxSingleTestWindow() {
        int defaultValue = 60000;
        String p = Configuration.getStringProperty(Integer.toString(60000), "servicecomb.loadbalance.isolation.maxSingleTestWindow");
        try {
            int result = Integer.parseInt(p);
            if (result >= 0) {
                return result;
            }
            return 60000;
        }
        catch (NumberFormatException e) {
            return 60000;
        }
    }

    public int getMinIsolationTime(String microservice) {
        int defaultValue = 3000;
        String p = Configuration.getStringProperty("3000", ROOT + microservice + ".isolation.minIsolationTime", "servicecomb.loadbalance.isolation.minIsolationTime");
        try {
            int result = Integer.parseInt(p);
            if (result >= 0) {
                return result;
            }
            return 3000;
        }
        catch (NumberFormatException e) {
            return 3000;
        }
    }

    public boolean isRecoverImmediatelyWhenSuccess(String microservice) {
        String p = Configuration.getStringProperty("true", ROOT + microservice + ".isolation.recoverImmediatelyWhenSuccess", "servicecomb.loadbalance.isolation.recoverImmediatelyWhenSuccess");
        return Boolean.parseBoolean(p);
    }

    public Map<String, String> getFlowsplitFilterOptions(String microservice) {
        String keyPrefix = String.format(TRANSACTIONCONTROL_OPTIONS_PREFIX_PATTERN, microservice);
        return ConfigurePropertyUtils.getPropertiesWithPrefix((String)keyPrefix);
    }

    public static String getStringProperty(String defaultValue, String ... keys) {
        for (String key : keys) {
            String property = DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            if (property == null) continue;
            return property;
        }
        return defaultValue;
    }

    public int getContinuousFailureThreshold(String microservice) {
        return this.getThreshold(microservice, FILTER_CONTINUOUS_FAILURE_THRESHOLD);
    }

    private int getThreshold(String microservice, String threshold) {
        int defaultValue = 5;
        String p = Configuration.getStringProperty("5", ROOT + microservice + ".isolation." + threshold, "servicecomb.loadbalance.isolation." + threshold);
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }
}

