/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian.generic.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class GenericObject
implements Serializable,
Comparable<GenericObject> {
    private static final long serialVersionUID = 3457717009326601317L;
    private String type;
    private Map<String, Object> fields = new TreeMap<String, Object>();

    private GenericObject() {
    }

    public GenericObject(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Object putField(String fieldName, Object value) {
        return this.fields.put(fieldName, value);
    }

    public Object getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.toString(new HashSet<Object>());
    }

    public String toString(Set<Object> set) {
        if (set.contains(this)) {
            return "<REF>";
        }
        set.add(this);
        StringBuilder sb = new StringBuilder("{type: " + this.type + ", fields: {");
        Iterator<Map.Entry<String, Object>> it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            sb.append(entry.getKey());
            sb.append("=");
            Object value = entry.getValue();
            if (value instanceof GenericObject) {
                sb.append(((GenericObject)value).toString(set));
            } else {
                sb.append(value);
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericObject that = (GenericObject)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return this.fields != null ? this.fields.equals(that.fields) : that.fields == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.fields != null ? this.getFieldsHashcode(this.fields) : 0);
        return result;
    }

    private int getFieldsHashcode(Map<String, Object> fields) {
        int h = 0;
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            if (entry.getValue() != null && entry.getValue().getClass() == GenericObject.class) {
                h += entry.getKey().hashCode();
                continue;
            }
            h += entry.hashCode();
        }
        return h;
    }

    @Override
    public int compareTo(GenericObject genericObject) {
        int result = this.type.compareTo(genericObject.getType());
        if (result != 0) {
            return result;
        }
        result = this.fields.size() - genericObject.getFields().size();
        if (result != 0) {
            return result;
        }
        Iterator<String> thisIterator = this.fields.keySet().iterator();
        Iterator<String> thatIterator = genericObject.getFields().keySet().iterator();
        while (thisIterator.hasNext() && thatIterator.hasNext()) {
            String thatKey;
            String thisKey = thisIterator.next();
            result = thisKey.compareTo(thatKey = thatIterator.next());
            if (result != 0) {
                return result;
            }
            Object thisValue = this.fields.get(thisKey);
            Object thatValue = genericObject.getFields().get(thatKey);
            if (thisValue == null && thatValue == null) continue;
            if (thisValue == null) {
                return -1;
            }
            if (thatValue == null) {
                return 1;
            }
            result = Integer.valueOf(thisValue.hashCode()).compareTo(thatValue.hashCode());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

