/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MessageArrivingListener;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.metrics.DefaultStoreMetricsManager;
import org.apache.rocketmq.store.metrics.RocksDBStoreMetricsManager;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.ConsumeQueueStoreInterface;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueStore;
import org.apache.rocketmq.store.stats.BrokerStatsManager;
import org.rocksdb.RocksDBException;

public class RocksDBMessageStore
extends DefaultMessageStore {
    private CommitLogDispatcherBuildRocksdbConsumeQueue dispatcherBuildRocksdbConsumeQueue;

    public RocksDBMessageStore(MessageStoreConfig messageStoreConfig, BrokerStatsManager brokerStatsManager, MessageArrivingListener messageArrivingListener, BrokerConfig brokerConfig, ConcurrentMap<String, TopicConfig> topicConfigTable) throws IOException {
        super(messageStoreConfig, brokerStatsManager, messageArrivingListener, brokerConfig, topicConfigTable);
        this.notifyMessageArriveInBatch = true;
    }

    @Override
    public ConsumeQueueStoreInterface createConsumeQueueStore() {
        return new RocksDBConsumeQueueStore(this);
    }

    @Override
    public DefaultMessageStore.CleanConsumeQueueService createCleanConsumeQueueService() {
        return new RocksDBCleanConsumeQueueService();
    }

    @Override
    public DefaultMessageStore.FlushConsumeQueueService createFlushConsumeQueueService() {
        return new RocksDBFlushConsumeQueueService();
    }

    @Override
    public DefaultMessageStore.CorrectLogicOffsetService createCorrectLogicOffsetService() {
        return new RocksDBCorrectLogicOffsetService();
    }

    @Override
    public void recoverTopicQueueTable() {
        this.consumeQueueStore.setTopicQueueTable(new ConcurrentHashMap<String, Long>());
    }

    @Override
    public ConsumeQueueInterface getConsumeQueue(String topic, int queueId) {
        return this.findConsumeQueue(topic, queueId);
    }

    @Override
    public void initMetrics(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        DefaultStoreMetricsManager.init(meter, attributesBuilderSupplier, this);
        RocksDBStoreMetricsManager.init(meter, attributesBuilderSupplier, this);
    }

    public CommitLogDispatcherBuildRocksdbConsumeQueue getDispatcherBuildRocksdbConsumeQueue() {
        return this.dispatcherBuildRocksdbConsumeQueue;
    }

    public void loadAndStartConsumerServiceOnly() {
        try {
            this.dispatcherBuildRocksdbConsumeQueue = new CommitLogDispatcherBuildRocksdbConsumeQueue();
            boolean loadResult = this.consumeQueueStore.load();
            if (!loadResult) {
                throw new RuntimeException("load consume queue failed");
            }
            super.loadCheckPoint();
            this.consumeQueueStore.start();
        }
        catch (Exception e) {
            ERROR_LOG.error("loadAndStartConsumerServiceOnly error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    class CommitLogDispatcherBuildRocksdbConsumeQueue
    implements CommitLogDispatcher {
        CommitLogDispatcherBuildRocksdbConsumeQueue() {
        }

        @Override
        public void dispatch(DispatchRequest request) throws RocksDBException {
            boolean enable = RocksDBMessageStore.this.getMessageStoreConfig().isRocksdbCQDoubleWriteEnable();
            if (!enable) {
                return;
            }
            int tranType = MessageSysFlag.getTransactionValue((int)request.getSysFlag());
            switch (tranType) {
                case 0: 
                case 8: {
                    RocksDBMessageStore.this.putMessagePositionInfo(request);
                    break;
                }
            }
        }
    }

    class RocksDBCorrectLogicOffsetService
    extends DefaultMessageStore.CorrectLogicOffsetService {
        RocksDBCorrectLogicOffsetService() {
        }

        @Override
        public void run() {
        }
    }

    class RocksDBFlushConsumeQueueService
    extends DefaultMessageStore.FlushConsumeQueueService {
        RocksDBFlushConsumeQueueService() {
        }

        @Override
        public void run() {
        }
    }

    class RocksDBCleanConsumeQueueService
    extends DefaultMessageStore.CleanConsumeQueueService {
        private final double diskSpaceWarningLevelRatio = Double.parseDouble(System.getProperty("rocketmq.broker.diskSpaceWarningLevelRatio", "0.90"));
        private final double diskSpaceCleanForciblyRatio = Double.parseDouble(System.getProperty("rocketmq.broker.diskSpaceCleanForciblyRatio", "0.85"));

        RocksDBCleanConsumeQueueService() {
        }

        @Override
        protected void deleteExpiredFiles() {
            long minOffset = RocksDBMessageStore.this.commitLog.getMinOffset();
            if (minOffset > this.lastPhysicalMinOffset) {
                this.lastPhysicalMinOffset = minOffset;
                boolean spaceFull = this.isSpaceToDelete();
                boolean timeUp = RocksDBMessageStore.this.cleanCommitLogService.isTimeToDelete();
                if (spaceFull || timeUp) {
                    RocksDBMessageStore.this.consumeQueueStore.cleanExpired(minOffset);
                }
                RocksDBMessageStore.this.indexService.deleteExpiredFile(minOffset);
            }
        }

        private boolean isSpaceToDelete() {
            boolean diskOk;
            double ratio = (double)RocksDBMessageStore.this.getMessageStoreConfig().getDiskMaxUsedSpaceRatio() / 100.0;
            String storePathLogics = StorePathConfigHelper.getStorePathConsumeQueue(RocksDBMessageStore.this.getMessageStoreConfig().getStorePathRootDir());
            double logicsRatio = UtilAll.getDiskPartitionSpaceUsedPercent((String)storePathLogics);
            if (logicsRatio > this.diskSpaceWarningLevelRatio) {
                boolean diskOk2 = RocksDBMessageStore.this.runningFlags.getAndMakeLogicDiskFull();
                if (diskOk2) {
                    LOGGER.error("logics disk maybe full soon " + logicsRatio + ", so mark disk full");
                }
            } else if (!(logicsRatio > this.diskSpaceCleanForciblyRatio) && !(diskOk = RocksDBMessageStore.this.runningFlags.getAndMakeLogicDiskOK())) {
                LOGGER.info("logics disk space OK " + logicsRatio + ", so mark disk ok");
            }
            if (logicsRatio < 0.0 || logicsRatio > ratio) {
                LOGGER.info("logics disk maybe full soon, so reclaim space, " + logicsRatio);
                return true;
            }
            return false;
        }
    }
}

