/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.qpid.server.queue.QueueConsumerNode;
import org.apache.qpid.server.queue.QueueConsumerNodeList;

final class QueueConsumerNodeListEntry {
    private static final AtomicIntegerFieldUpdater<QueueConsumerNodeListEntry> DELETED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QueueConsumerNodeListEntry.class, "_deleted");
    private volatile int _deleted;
    private static final AtomicReferenceFieldUpdater<QueueConsumerNodeListEntry, QueueConsumerNodeListEntry> NEXT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(QueueConsumerNodeListEntry.class, QueueConsumerNodeListEntry.class, "_next");
    private volatile QueueConsumerNodeListEntry _next;
    private volatile QueueConsumerNode _queueConsumerNode;
    private final QueueConsumerNodeList _list;

    QueueConsumerNodeListEntry(QueueConsumerNodeList list, QueueConsumerNode queueConsumerNode) {
        this._list = list;
        this._queueConsumerNode = queueConsumerNode;
    }

    public QueueConsumerNodeListEntry(QueueConsumerNodeList list) {
        this._list = list;
        this._queueConsumerNode = null;
        DELETED_UPDATER.set(this, 1);
    }

    public QueueConsumerNode getQueueConsumerNode() {
        return this._queueConsumerNode;
    }

    public QueueConsumerNodeListEntry findNext() {
        QueueConsumerNodeListEntry next = this.nextNode();
        while (next != null && next.isDeleted()) {
            QueueConsumerNodeListEntry newNext = next.nextNode();
            if (newNext != null) {
                NEXT_UPDATER.compareAndSet(this, next, newNext);
                next = this.nextNode();
                continue;
            }
            next = null;
        }
        return next;
    }

    protected QueueConsumerNodeListEntry nextNode() {
        return this._next;
    }

    boolean setNext(QueueConsumerNodeListEntry node) {
        return NEXT_UPDATER.compareAndSet(this, null, node);
    }

    public void remove() {
        this._list.removeEntry(this);
    }

    public boolean isDeleted() {
        return this._deleted == 1;
    }

    boolean setDeleted() {
        boolean deleted = DELETED_UPDATER.compareAndSet(this, 0, 1);
        if (deleted) {
            this._queueConsumerNode = null;
        }
        return deleted;
    }
}

