/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnDcp_Pdu_AlarmLow extends PnDcp_Pdu implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final int alarmDstEndpoint;
  protected final int alarmSrcEndpoint;
  protected final byte version;
  protected final byte errorType;
  protected final byte tAck;
  protected final byte windowSize;
  protected final int senSeqNum;
  protected final int ackSeqNum;
  protected final byte[] varPart;

  public PnDcp_Pdu_AlarmLow(
      int frameIdValue,
      int alarmDstEndpoint,
      int alarmSrcEndpoint,
      byte version,
      byte errorType,
      byte tAck,
      byte windowSize,
      int senSeqNum,
      int ackSeqNum,
      byte[] varPart) {
    super(frameIdValue);
    this.alarmDstEndpoint = alarmDstEndpoint;
    this.alarmSrcEndpoint = alarmSrcEndpoint;
    this.version = version;
    this.errorType = errorType;
    this.tAck = tAck;
    this.windowSize = windowSize;
    this.senSeqNum = senSeqNum;
    this.ackSeqNum = ackSeqNum;
    this.varPart = varPart;
  }

  public int getAlarmDstEndpoint() {
    return alarmDstEndpoint;
  }

  public int getAlarmSrcEndpoint() {
    return alarmSrcEndpoint;
  }

  public byte getVersion() {
    return version;
  }

  public byte getErrorType() {
    return errorType;
  }

  public byte getTAck() {
    return tAck;
  }

  public byte getWindowSize() {
    return windowSize;
  }

  public int getSenSeqNum() {
    return senSeqNum;
  }

  public int getAckSeqNum() {
    return ackSeqNum;
  }

  public byte[] getVarPart() {
    return varPart;
  }

  @Override
  protected void serializePnDcp_PduChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnDcp_Pdu_AlarmLow");

    // Simple Field (alarmDstEndpoint)
    writeSimpleField(
        "alarmDstEndpoint",
        alarmDstEndpoint,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (alarmSrcEndpoint)
    writeSimpleField(
        "alarmSrcEndpoint",
        alarmSrcEndpoint,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (version)
    writeSimpleField(
        "version",
        version,
        writeUnsignedByte(writeBuffer, 4),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (errorType)
    writeSimpleField(
        "errorType",
        errorType,
        writeUnsignedByte(writeBuffer, 4),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (tAck)
    writeSimpleField(
        "tAck",
        tAck,
        writeUnsignedByte(writeBuffer, 4),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (windowSize)
    writeSimpleField(
        "windowSize",
        windowSize,
        writeUnsignedByte(writeBuffer, 4),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (senSeqNum)
    writeSimpleField(
        "senSeqNum",
        senSeqNum,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (ackSeqNum)
    writeSimpleField(
        "ackSeqNum",
        ackSeqNum,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Implicit Field (varPartLen) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    int varPartLen = (int) (COUNT(getVarPart()));
    writeImplicitField(
        "varPartLen",
        varPartLen,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Array Field (varPart)
    writeByteArrayField(
        "varPart",
        varPart,
        writeByteArray(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnDcp_Pdu_AlarmLow");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PnDcp_Pdu_AlarmLow _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (alarmDstEndpoint)
    lengthInBits += 16;

    // Simple field (alarmSrcEndpoint)
    lengthInBits += 16;

    // Simple field (version)
    lengthInBits += 4;

    // Simple field (errorType)
    lengthInBits += 4;

    // Simple field (tAck)
    lengthInBits += 4;

    // Simple field (windowSize)
    lengthInBits += 4;

    // Simple field (senSeqNum)
    lengthInBits += 16;

    // Simple field (ackSeqNum)
    lengthInBits += 16;

    // Implicit Field (varPartLen)
    lengthInBits += 16;

    // Array field
    if (varPart != null) {
      lengthInBits += 8 * varPart.length;
    }

    return lengthInBits;
  }

  public static PnDcp_PduBuilder staticParsePnDcp_PduBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnDcp_Pdu_AlarmLow");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int alarmDstEndpoint =
        readSimpleField(
            "alarmDstEndpoint",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int alarmSrcEndpoint =
        readSimpleField(
            "alarmSrcEndpoint",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    byte version =
        readSimpleField(
            "version",
            readUnsignedByte(readBuffer, 4),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    byte errorType =
        readSimpleField(
            "errorType",
            readUnsignedByte(readBuffer, 4),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    byte tAck =
        readSimpleField(
            "tAck",
            readUnsignedByte(readBuffer, 4),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    byte windowSize =
        readSimpleField(
            "windowSize",
            readUnsignedByte(readBuffer, 4),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int senSeqNum =
        readSimpleField(
            "senSeqNum",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int ackSeqNum =
        readSimpleField(
            "ackSeqNum",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int varPartLen =
        readImplicitField(
            "varPartLen",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    byte[] varPart =
        readBuffer.readByteArray(
            "varPart", Math.toIntExact(varPartLen), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnDcp_Pdu_AlarmLow");
    // Create the instance
    return new PnDcp_Pdu_AlarmLowBuilderImpl(
        alarmDstEndpoint,
        alarmSrcEndpoint,
        version,
        errorType,
        tAck,
        windowSize,
        senSeqNum,
        ackSeqNum,
        varPart);
  }

  public static class PnDcp_Pdu_AlarmLowBuilderImpl implements PnDcp_Pdu.PnDcp_PduBuilder {
    private final int alarmDstEndpoint;
    private final int alarmSrcEndpoint;
    private final byte version;
    private final byte errorType;
    private final byte tAck;
    private final byte windowSize;
    private final int senSeqNum;
    private final int ackSeqNum;
    private final byte[] varPart;

    public PnDcp_Pdu_AlarmLowBuilderImpl(
        int alarmDstEndpoint,
        int alarmSrcEndpoint,
        byte version,
        byte errorType,
        byte tAck,
        byte windowSize,
        int senSeqNum,
        int ackSeqNum,
        byte[] varPart) {
      this.alarmDstEndpoint = alarmDstEndpoint;
      this.alarmSrcEndpoint = alarmSrcEndpoint;
      this.version = version;
      this.errorType = errorType;
      this.tAck = tAck;
      this.windowSize = windowSize;
      this.senSeqNum = senSeqNum;
      this.ackSeqNum = ackSeqNum;
      this.varPart = varPart;
    }

    public PnDcp_Pdu_AlarmLow build(int frameIdValue) {
      PnDcp_Pdu_AlarmLow pnDcp_Pdu_AlarmLow =
          new PnDcp_Pdu_AlarmLow(
              frameIdValue,
              alarmDstEndpoint,
              alarmSrcEndpoint,
              version,
              errorType,
              tAck,
              windowSize,
              senSeqNum,
              ackSeqNum,
              varPart);
      return pnDcp_Pdu_AlarmLow;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnDcp_Pdu_AlarmLow)) {
      return false;
    }
    PnDcp_Pdu_AlarmLow that = (PnDcp_Pdu_AlarmLow) o;
    return (getAlarmDstEndpoint() == that.getAlarmDstEndpoint())
        && (getAlarmSrcEndpoint() == that.getAlarmSrcEndpoint())
        && (getVersion() == that.getVersion())
        && (getErrorType() == that.getErrorType())
        && (getTAck() == that.getTAck())
        && (getWindowSize() == that.getWindowSize())
        && (getSenSeqNum() == that.getSenSeqNum())
        && (getAckSeqNum() == that.getAckSeqNum())
        && (getVarPart() == that.getVarPart())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getAlarmDstEndpoint(),
        getAlarmSrcEndpoint(),
        getVersion(),
        getErrorType(),
        getTAck(),
        getWindowSize(),
        getSenSeqNum(),
        getAckSeqNum(),
        getVarPart());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
