/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum KnxInterfaceObjectProperty {
  PID_UNKNOWN(
      (long) 0L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "Unknown Interface Object Property",
      (short) 0,
      KnxInterfaceObjectType.OT_UNKNOWN),
  PID_GENERAL_OBJECT_TYPE(
      (long) 1L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "Interface Object Type",
      (short) 1,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_OBJECT_NAME(
      (long) 2L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "Interface Object Name",
      (short) 2,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_SEMAPHOR(
      (long) 3L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "Semaphor",
      (short) 3,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_GROUP_OBJECT_REFERENCE(
      (long) 4L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "Group Object Reference",
      (short) 4,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_LOAD_STATE_CONTROL(
      (long) 5L,
      KnxPropertyDataType.PDT_CONTROL,
      (String) "Load Control",
      (short) 5,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_RUN_STATE_CONTROL(
      (long) 6L,
      KnxPropertyDataType.PDT_CONTROL,
      (String) "Run Control",
      (short) 6,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_TABLE_REFERENCE(
      (long) 7L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "Table Reference",
      (short) 7,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_SERVICE_CONTROL(
      (long) 8L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "Service Control",
      (short) 8,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_FIRMWARE_REVISION(
      (long) 9L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "Firmware Revision",
      (short) 9,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_SERVICES_SUPPORTED(
      (long) 10L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "Services Supported",
      (short) 10,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_SERIAL_NUMBER(
      (long) 11L,
      KnxPropertyDataType.PDT_GENERIC_06,
      (String) "KNX Serial Number",
      (short) 11,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_MANUFACTURER_ID(
      (long) 12L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "Manufacturer Identifier",
      (short) 12,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_PROGRAM_VERSION(
      (long) 13L,
      KnxPropertyDataType.PDT_GENERIC_05,
      (String) "Application Version",
      (short) 13,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_DEVICE_CONTROL(
      (long) 14L,
      KnxPropertyDataType.PDT_BITSET8,
      (String) "Device Control",
      (short) 14,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_ORDER_INFO(
      (long) 15L,
      KnxPropertyDataType.PDT_GENERIC_10,
      (String) "Order Info",
      (short) 15,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_PEI_TYPE(
      (long) 16L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "PEI Type",
      (short) 16,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_PORT_CONFIGURATION(
      (long) 17L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "PortADDR",
      (short) 17,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_POLL_GROUP_SETTINGS(
      (long) 18L,
      KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS,
      (String) "Polling Group Settings",
      (short) 18,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_MANUFACTURER_DATA(
      (long) 19L,
      KnxPropertyDataType.PDT_GENERIC_04,
      (String) "Manufacturer Data",
      (short) 19,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_ENABLE(
      (long) 20L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 20,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_DESCRIPTION(
      (long) 21L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "Description",
      (short) 21,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_FILE(
      (long) 22L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 22,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_TABLE(
      (long) 23L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "Table",
      (short) 23,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_ENROL(
      (long) 24L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "Interface Object Link",
      (short) 24,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_VERSION(
      (long) 25L,
      KnxPropertyDataType.PDT_VERSION,
      (String) "Version",
      (short) 25,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_GROUP_OBJECT_LINK(
      (long) 26L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "Group Address Assignment",
      (short) 26,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_MCB_TABLE(
      (long) 27L,
      KnxPropertyDataType.PDT_GENERIC_08,
      (String) "Memory Control Table",
      (short) 27,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_ERROR_CODE(
      (long) 28L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "Error Code",
      (short) 28,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_OBJECT_INDEX(
      (long) 29L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "Object Index",
      (short) 29,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_GENERAL_DOWNLOAD_COUNTER(
      (long) 30L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "Download Counter",
      (short) 30,
      KnxInterfaceObjectType.OT_GENERAL),
  PID_DEVICE_ROUTING_COUNT(
      (long) 31L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "Routing Count",
      (short) 51,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_MAX_RETRY_COUNT(
      (long) 32L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "Maximum Retry Count",
      (short) 52,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_ERROR_FLAGS(
      (long) 33L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "Error Flags",
      (short) 53,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_PROGMODE(
      (long) 34L,
      KnxPropertyDataType.PDT_BITSET8,
      (String) "Programming Mode",
      (short) 54,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_PRODUCT_ID(
      (long) 35L,
      KnxPropertyDataType.PDT_GENERIC_10,
      (String) "Product Identification",
      (short) 55,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_MAX_APDULENGTH(
      (long) 36L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "Max. APDU-Length",
      (short) 56,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_SUBNET_ADDR(
      (long) 37L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "Subnetwork Address",
      (short) 57,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_DEVICE_ADDR(
      (long) 38L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "Device Address",
      (short) 58,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_PB_CONFIG(
      (long) 39L,
      KnxPropertyDataType.PDT_GENERIC_04,
      (String) "Config Link",
      (short) 59,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_ADDR_REPORT(
      (long) 40L,
      KnxPropertyDataType.PDT_GENERIC_06,
      (String) "",
      (short) 60,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_ADDR_CHECK(
      (long) 41L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "",
      (short) 61,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_OBJECT_VALUE(
      (long) 42L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 62,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_OBJECTLINK(
      (long) 43L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 63,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_APPLICATION(
      (long) 44L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 64,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_PARAMETER(
      (long) 45L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 65,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_OBJECTADDRESS(
      (long) 46L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 66,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_PSU_TYPE(
      (long) 47L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "",
      (short) 67,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_PSU_STATUS(
      (long) 48L,
      KnxPropertyDataType.PDT_BINARY_INFORMATION,
      (String) "",
      (short) 68,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_PSU_ENABLE(
      (long) 49L,
      KnxPropertyDataType.PDT_ENUM8,
      (String) "",
      (short) 69,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_DOMAIN_ADDRESS(
      (long) 50L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "Domain Address",
      (short) 70,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_IO_LIST(
      (long) 51L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "",
      (short) 71,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_MGT_DESCRIPTOR_01(
      (long) 52L,
      KnxPropertyDataType.PDT_GENERIC_10,
      (String) "Management Descriptor 1",
      (short) 72,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_PL110_PARAM(
      (long) 53L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "PL110 Parameters",
      (short) 73,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_RF_REPEAT_COUNTER(
      (long) 54L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 74,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_RECEIVE_BLOCK_TABLE(
      (long) 55L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 75,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_RANDOM_PAUSE_TABLE(
      (long) 56L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 76,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_RECEIVE_BLOCK_NR(
      (long) 57L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 77,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_HARDWARE_TYPE(
      (long) 58L,
      KnxPropertyDataType.PDT_GENERIC_06,
      (String) "Hardware Type",
      (short) 78,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_RETRANSMITTER_NUMBER(
      (long) 59L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 79,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_SERIAL_NR_TABLE(
      (long) 60L,
      KnxPropertyDataType.PDT_GENERIC_06,
      (String) "",
      (short) 80,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_BIBATMASTER_ADDRESS(
      (long) 61L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "",
      (short) 81,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_RF_DOMAIN_ADDRESS(
      (long) 62L,
      KnxPropertyDataType.PDT_GENERIC_06,
      (String) "RF Domain Address",
      (short) 82,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_DEVICE_DESCRIPTOR(
      (long) 63L,
      KnxPropertyDataType.PDT_GENERIC_02,
      (String) "",
      (short) 83,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_METERING_FILTER_TABLE(
      (long) 64L,
      KnxPropertyDataType.PDT_GENERIC_08,
      (String) "",
      (short) 84,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_TIME_BASE(
      (long) 65L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "",
      (short) 85,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_NO_OF_TELEGR(
      (long) 66L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "",
      (short) 86,
      KnxInterfaceObjectType.OT_DEVICE),
  PID_GROUP_OBJECT_TABLE_GRPOBJTABLE(
      (long) 67L,
      KnxPropertyDataType.PDT_GENERIC_06,
      (String) "",
      (short) 51,
      KnxInterfaceObjectType.OT_GROUP_OBJECT_TABLE),
  PID_GROUP_OBJECT_TABLE_EXT_GRPOBJREFERENCE(
      (long) 68L,
      KnxPropertyDataType.PDT_GENERIC_08,
      (String) "",
      (short) 52,
      KnxInterfaceObjectType.OT_GROUP_OBJECT_TABLE),
  PID_ROUTER_LINE_STATUS(
      (long) 69L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "",
      (short) 51,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_MAIN_LCCONFIG(
      (long) 70L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "",
      (short) 52,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_SUB_LCCONFIG(
      (long) 71L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "",
      (short) 53,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_MAIN_LCGRPCONFIG(
      (long) 72L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "",
      (short) 54,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_SUB_LCGRPCONFIG(
      (long) 73L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "",
      (short) 55,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_ROUTETABLE_CONTROL(
      (long) 74L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 56,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_COUPL_SERV_CONTROL(
      (long) 75L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "",
      (short) 57,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_MAX_ROUTER_APDU_LENGTH(
      (long) 76L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "",
      (short) 58,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_MEDIUM(
      (long) 77L,
      KnxPropertyDataType.PDT_ENUM8,
      (String) "",
      (short) 63,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_FILTER_TABLE_USE(
      (long) 78L,
      KnxPropertyDataType.PDT_BINARY_INFORMATION,
      (String) "",
      (short) 67,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_ROUTER_RF_ENABLE_SBC(
      (long) 79L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 112,
      KnxInterfaceObjectType.OT_ROUTER),
  PID_KNXIP_PARAMETER_PROJECT_INSTALLATION_ID(
      (long) 80L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "Project Installation Identification",
      (short) 51,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_KNX_INDIVIDUAL_ADDRESS(
      (long) 81L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "KNX Individual Address",
      (short) 52,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_ADDITIONAL_INDIVIDUAL_ADDRESSES(
      (long) 82L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "Additional Individual Addresses",
      (short) 53,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_CURRENT_IP_ASSIGNMENT_METHOD(
      (long) 83L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 54,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_IP_ASSIGNMENT_METHOD(
      (long) 84L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 55,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_IP_CAPABILITIES(
      (long) 85L,
      KnxPropertyDataType.PDT_BITSET8,
      (String) "",
      (short) 56,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_CURRENT_IP_ADDRESS(
      (long) 86L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 57,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_CURRENT_SUBNET_MASK(
      (long) 87L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 58,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_CURRENT_DEFAULT_GATEWAY(
      (long) 88L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 59,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_IP_ADDRESS(
      (long) 89L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 60,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_SUBNET_MASK(
      (long) 90L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 61,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_DEFAULT_GATEWAY(
      (long) 91L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 62,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_DHCP_BOOTP_SERVER(
      (long) 92L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 63,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_MAC_ADDRESS(
      (long) 93L,
      KnxPropertyDataType.PDT_GENERIC_06,
      (String) "",
      (short) 64,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_SYSTEM_SETUP_MULTICAST_ADDRESS(
      (long) 94L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 65,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_ROUTING_MULTICAST_ADDRESS(
      (long) 95L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 66,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_TTL(
      (long) 96L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 67,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_CAPABILITIES(
      (long) 97L,
      KnxPropertyDataType.PDT_BITSET16,
      (String) "",
      (short) 68,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_STATE(
      (long) 98L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 69,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_KNXNETIP_ROUTING_CAPABILITIES(
      (long) 99L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 70,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_PRIORITY_FIFO_ENABLED(
      (long) 100L,
      KnxPropertyDataType.PDT_BINARY_INFORMATION,
      (String) "",
      (short) 71,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_IP(
      (long) 101L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "",
      (short) 72,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_KNX(
      (long) 102L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "",
      (short) 73,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_IP(
      (long) 103L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 74,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_KNX(
      (long) 104L,
      KnxPropertyDataType.PDT_UNSIGNED_LONG,
      (String) "",
      (short) 75,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_FRIENDLY_NAME(
      (long) 105L,
      KnxPropertyDataType.PDT_UNSIGNED_CHAR,
      (String) "",
      (short) 76,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_BACKBONE_KEY(
      (long) 106L,
      KnxPropertyDataType.PDT_GENERIC_16,
      (String) "",
      (short) 91,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_DEVICE_AUTHENTICATION_CODE(
      (long) 107L,
      KnxPropertyDataType.PDT_GENERIC_16,
      (String) "",
      (short) 92,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_PASSWORD_HASHES(
      (long) 108L,
      KnxPropertyDataType.PDT_GENERIC_16,
      (String) "",
      (short) 93,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_SECURED_SERVICE_FAMILIES(
      (long) 109L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 94,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_MULTICAST_LATENCY_TOLERANCE(
      (long) 110L,
      KnxPropertyDataType.PDT_UNSIGNED_INT,
      (String) "",
      (short) 95,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_SYNC_LATENCY_FRACTION(
      (long) 111L,
      KnxPropertyDataType.PDT_SCALING,
      (String) "",
      (short) 96,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_KNXIP_PARAMETER_TUNNELLING_USERS(
      (long) 112L,
      KnxPropertyDataType.PDT_GENERIC_02,
      (String) "",
      (short) 97,
      KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
  PID_SECURITY_SECURITY_MODE(
      (long) 113L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 51,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_P2P_KEY_TABLE(
      (long) 114L,
      KnxPropertyDataType.PDT_GENERIC_18,
      (String) "",
      (short) 52,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_GRP_KEY_TABLE(
      (long) 115L,
      KnxPropertyDataType.PDT_GENERIC_18,
      (String) "",
      (short) 53,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_SECURITY_INDIVIDUAL_ADDRESS_TABLE(
      (long) 116L,
      KnxPropertyDataType.PDT_GENERIC_08,
      (String) "",
      (short) 54,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_SECURITY_FAILURES_LOG(
      (long) 117L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 55,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_SKI_TOOL(
      (long) 118L,
      KnxPropertyDataType.PDT_GENERIC_16,
      (String) "",
      (short) 56,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_SECURITY_REPORT(
      (long) 119L,
      KnxPropertyDataType.PDT_BITSET8,
      (String) "",
      (short) 57,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_SECURITY_REPORT_CONTROL(
      (long) 120L,
      KnxPropertyDataType.PDT_BINARY_INFORMATION,
      (String) "",
      (short) 58,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_SEQUENCE_NUMBER_SENDING(
      (long) 121L,
      KnxPropertyDataType.PDT_GENERIC_06,
      (String) "",
      (short) 59,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_ZONE_KEYS_TABLE(
      (long) 122L,
      KnxPropertyDataType.PDT_GENERIC_19,
      (String) "",
      (short) 60,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_SECURITY_GO_SECURITY_FLAGS(
      (long) 123L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "",
      (short) 61,
      KnxInterfaceObjectType.OT_SECURITY),
  PID_RF_MEDIUM_RF_MULTI_TYPE(
      (long) 124L,
      KnxPropertyDataType.PDT_GENERIC_01,
      (String) "",
      (short) 51,
      KnxInterfaceObjectType.OT_RF_MEDIUM),
  PID_RF_MEDIUM_RF_DOMAIN_ADDRESS(
      (long) 125L,
      KnxPropertyDataType.PDT_GENERIC_06,
      (String) "",
      (short) 56,
      KnxInterfaceObjectType.OT_RF_MEDIUM),
  PID_RF_MEDIUM_RF_RETRANSMITTER(
      (long) 126L,
      KnxPropertyDataType.PDT_BINARY_INFORMATION,
      (String) "",
      (short) 57,
      KnxInterfaceObjectType.OT_RF_MEDIUM),
  PID_RF_MEDIUM_SECURITY_REPORT_CONTROL(
      (long) 127L,
      KnxPropertyDataType.PDT_BINARY_INFORMATION,
      (String) "",
      (short) 58,
      KnxInterfaceObjectType.OT_RF_MEDIUM),
  PID_RF_MEDIUM_RF_FILTERING_MODE_SELECT(
      (long) 128L,
      KnxPropertyDataType.PDT_BITSET8,
      (String) "",
      (short) 59,
      KnxInterfaceObjectType.OT_RF_MEDIUM),
  PID_RF_MEDIUM_RF_BIDIR_TIMEOUT(
      (long) 129L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 60,
      KnxInterfaceObjectType.OT_RF_MEDIUM),
  PID_RF_MEDIUM_RF_DIAG_SA_FILTER_TABLE(
      (long) 130L,
      KnxPropertyDataType.PDT_GENERIC_03,
      (String) "",
      (short) 61,
      KnxInterfaceObjectType.OT_RF_MEDIUM),
  PID_RF_MEDIUM_RF_DIAG_QUALITY_TABLE(
      (long) 131L,
      KnxPropertyDataType.PDT_GENERIC_04,
      (String) "",
      (short) 62,
      KnxInterfaceObjectType.OT_RF_MEDIUM),
  PID_RF_MEDIUM_RF_DIAG_PROBE(
      (long) 132L,
      KnxPropertyDataType.PDT_FUNCTION,
      (String) "",
      (short) 63,
      KnxInterfaceObjectType.OT_RF_MEDIUM),
  PID_INDOOR_BRIGHTNESS_SENSOR_CHANGE_OF_VALUE(
      (long) 133L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 110,
      KnxInterfaceObjectType.OT_INDOOR_BRIGHTNESS_SENSOR),
  PID_INDOOR_BRIGHTNESS_SENSOR_REPETITION_TIME(
      (long) 134L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 111,
      KnxInterfaceObjectType.OT_INDOOR_BRIGHTNESS_SENSOR),
  PID_INDOOR_LUMINANCE_SENSOR_CHANGE_OF_VALUE(
      (long) 135L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 110,
      KnxInterfaceObjectType.OT_INDOOR_LUMINANCE_SENSOR),
  PID_INDOOR_LUMINANCE_SENSOR_REPETITION_TIME(
      (long) 136L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 111,
      KnxInterfaceObjectType.OT_INDOOR_LUMINANCE_SENSOR),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_ON_DELAY(
      (long) 137L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 101,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_OFF_DELAY(
      (long) 138L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 102,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_DURATION(
      (long) 139L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 103,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_PREWARNING_DURATION(
      (long) 140L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 104,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME(
      (long) 141L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 105,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY(
      (long) 142L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 106,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING(
      (long) 143L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 107,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING(
      (long) 144L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 108,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP(
      (long) 145L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 109,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN(
      (long) 146L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 110,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_OUTPUT_STATE(
      (long) 147L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 111,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION(
      (long) 148L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 112,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE(
      (long) 149L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 113,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE(
      (long) 150L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 114,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_LOCK_STATE(
      (long) 151L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 115,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_UNLOCK_STATE(
      (long) 152L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 116,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STATE_FOR_SCENE_NUMBER(
      (long) 153L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 117,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE(
      (long) 154L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 118,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_STATE(
      (long) 155L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 119,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_2(
      (long) 156L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 120,
      KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_ON_DELAY(
      (long) 157L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 101,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_OFF_DELAY(
      (long) 158L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 102,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_SWITCH_OFF_BRIGHTNESS_DELAY_TIME(
      (long) 159L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 103,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_DURATION(
      (long) 160L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 104,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_PREWARNING_DURATION(
      (long) 161L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 105,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME(
      (long) 162L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 106,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY(
      (long) 163L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 107,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED(
      (long) 164L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 108,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME(
      (long) 165L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 109,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_ON_SET_VALUE(
      (long) 166L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 110,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_OFF(
      (long) 167L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 111,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_ON_SET_VALUE(
      (long) 168L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 112,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_OFF(
      (long) 169L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 113,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_SWITCFH_OFF_BRIGHTNESS(
      (long) 170L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 114,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_MINIMUM_SET_VALUE(
      (long) 171L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 115,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_MAXIMUM_SET_VALUE(
      (long) 172L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 116,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_SWITCH_ON_SET_VALUE(
      (long) 173L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 117,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_DIMM_MODE_SELECTION(
      (long) 174L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 118,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_RELATIV_OFF_ENABLE(
      (long) 175L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 119,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_MEMORY_FUNCTION(
      (long) 176L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 120,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION(
      (long) 177L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 121,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE(
      (long) 178L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 122,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE(
      (long) 179L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 123,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING(
      (long) 180L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 124,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING(
      (long) 181L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 125,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_LOCK_SETVALUE(
      (long) 182L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 126,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_UNLOCK_SETVALUE(
      (long) 183L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 127,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_BIGHTNESS_FOR_SCENE(
      (long) 184L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 128,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE(
      (long) 185L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 129,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_DELTA_DIMMING_VALUE(
      (long) 186L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 130,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP(
      (long) 187L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 131,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_SET_VALUE(
      (long) 188L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 132,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN(
      (long) 189L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 133,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_DOWN_SET_VALUE(
      (long) 190L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 134,
      KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
  PID_DIMMING_SENSOR_BASIC_ON_OFF_ACTION(
      (long) 191L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 51,
      KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC),
  PID_DIMMING_SENSOR_BASIC_ENABLE_TOGGLE_MODE(
      (long) 192L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 52,
      KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC),
  PID_DIMMING_SENSOR_BASIC_ABSOLUTE_SETVALUE(
      (long) 193L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 53,
      KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC),
  PID_SWITCHING_SENSOR_BASIC_ON_OFF_ACTION(
      (long) 194L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 51,
      KnxInterfaceObjectType.OT_SWITCHING_SENSOR_BASIC),
  PID_SWITCHING_SENSOR_BASIC_ENABLE_TOGGLE_MODE(
      (long) 195L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 52,
      KnxInterfaceObjectType.OT_SWITCHING_SENSOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_REVERSION_PAUSE_TIME(
      (long) 196L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 51,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_MOVE_UP_DOWN_TIME(
      (long) 197L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 52,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_SLAT_STEP_TIME(
      (long) 198L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 53,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_MOVE_PRESET_POSITION_TIME(
      (long) 199L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 54,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_IN_PERCENT(
      (long) 200L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 55,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_LENGTH(
      (long) 201L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 57,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_PERCENT(
      (long) 202L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 58,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_ANGLE(
      (long) 203L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 60,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_REACTION_WIND_ALARM(
      (long) 204L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 61,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_WIND_ALARM(
      (long) 205L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 62,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_REACTION_ON_RAIN_ALARM(
      (long) 206L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 63,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_RAIN_ALARM(
      (long) 207L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 64,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_REACTION_FROST_ALARM(
      (long) 208L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 65,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_FROST_ALARM(
      (long) 209L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 66,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_MAX_SLAT_MOVE_TIME(
      (long) 210L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 67,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_ENABLE_BLINDS_MODE(
      (long) 211L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 68,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_ACTUATOR_BASIC_STORAGE_FUNCTIONS_FOR_SCENE(
      (long) 212L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 69,
      KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
  PID_SUNBLIND_SENSOR_BASIC_ENABLE_BLINDS_MODE(
      (long) 213L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 51,
      KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC),
  PID_SUNBLIND_SENSOR_BASIC_UP_DOWN_ACTION(
      (long) 214L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 52,
      KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC),
  PID_SUNBLIND_SENSOR_BASIC_ENABLE_TOGGLE_MODE(
      (long) 215L,
      KnxPropertyDataType.PDT_UNKNOWN,
      (String) "",
      (short) 53,
      KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC);
  private static final Map<Long, KnxInterfaceObjectProperty> map;

  static {
    map = new HashMap<>();
    for (KnxInterfaceObjectProperty value : KnxInterfaceObjectProperty.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;
  private final KnxPropertyDataType propertyDataType;
  private final String name;
  private final short propertyId;
  private final KnxInterfaceObjectType objectType;

  KnxInterfaceObjectProperty(
      long value,
      KnxPropertyDataType propertyDataType,
      String name,
      short propertyId,
      KnxInterfaceObjectType objectType) {
    this.value = value;
    this.propertyDataType = propertyDataType;
    this.name = name;
    this.propertyId = propertyId;
    this.objectType = objectType;
  }

  public long getValue() {
    return value;
  }

  public KnxPropertyDataType getPropertyDataType() {
    return propertyDataType;
  }

  public static KnxInterfaceObjectProperty firstEnumForFieldPropertyDataType(
      KnxPropertyDataType fieldValue) {
    for (KnxInterfaceObjectProperty _val : KnxInterfaceObjectProperty.values()) {
      if (_val.getPropertyDataType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxInterfaceObjectProperty> enumsForFieldPropertyDataType(
      KnxPropertyDataType fieldValue) {
    List<KnxInterfaceObjectProperty> _values = new ArrayList<>();
    for (KnxInterfaceObjectProperty _val : KnxInterfaceObjectProperty.values()) {
      if (_val.getPropertyDataType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getName() {
    return name;
  }

  public static KnxInterfaceObjectProperty firstEnumForFieldName(String fieldValue) {
    for (KnxInterfaceObjectProperty _val : KnxInterfaceObjectProperty.values()) {
      if (_val.getName().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxInterfaceObjectProperty> enumsForFieldName(String fieldValue) {
    List<KnxInterfaceObjectProperty> _values = new ArrayList<>();
    for (KnxInterfaceObjectProperty _val : KnxInterfaceObjectProperty.values()) {
      if (_val.getName().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public short getPropertyId() {
    return propertyId;
  }

  public static KnxInterfaceObjectProperty firstEnumForFieldPropertyId(short fieldValue) {
    for (KnxInterfaceObjectProperty _val : KnxInterfaceObjectProperty.values()) {
      if (_val.getPropertyId() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxInterfaceObjectProperty> enumsForFieldPropertyId(short fieldValue) {
    List<KnxInterfaceObjectProperty> _values = new ArrayList<>();
    for (KnxInterfaceObjectProperty _val : KnxInterfaceObjectProperty.values()) {
      if (_val.getPropertyId() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public KnxInterfaceObjectType getObjectType() {
    return objectType;
  }

  public static KnxInterfaceObjectProperty firstEnumForFieldObjectType(
      KnxInterfaceObjectType fieldValue) {
    for (KnxInterfaceObjectProperty _val : KnxInterfaceObjectProperty.values()) {
      if (_val.getObjectType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxInterfaceObjectProperty> enumsForFieldObjectType(
      KnxInterfaceObjectType fieldValue) {
    List<KnxInterfaceObjectProperty> _values = new ArrayList<>();
    for (KnxInterfaceObjectProperty _val : KnxInterfaceObjectProperty.values()) {
      if (_val.getObjectType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static KnxInterfaceObjectProperty enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
