/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HVACZoneList implements Message {

  // Properties.
  protected final boolean expansion;
  protected final boolean zone6;
  protected final boolean zone5;
  protected final boolean zone4;
  protected final boolean zone3;
  protected final boolean zone2;
  protected final boolean zone1;
  protected final boolean zone0;

  public HVACZoneList(
      boolean expansion,
      boolean zone6,
      boolean zone5,
      boolean zone4,
      boolean zone3,
      boolean zone2,
      boolean zone1,
      boolean zone0) {
    super();
    this.expansion = expansion;
    this.zone6 = zone6;
    this.zone5 = zone5;
    this.zone4 = zone4;
    this.zone3 = zone3;
    this.zone2 = zone2;
    this.zone1 = zone1;
    this.zone0 = zone0;
  }

  public boolean getExpansion() {
    return expansion;
  }

  public boolean getZone6() {
    return zone6;
  }

  public boolean getZone5() {
    return zone5;
  }

  public boolean getZone4() {
    return zone4;
  }

  public boolean getZone3() {
    return zone3;
  }

  public boolean getZone2() {
    return zone2;
  }

  public boolean getZone1() {
    return zone1;
  }

  public boolean getZone0() {
    return zone0;
  }

  public boolean getUnswitchedZone() {
    return (boolean) (getZone0());
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HVACZoneList");

    // Simple Field (expansion)
    writeSimpleField("expansion", expansion, writeBoolean(writeBuffer));

    // Simple Field (zone6)
    writeSimpleField("zone6", zone6, writeBoolean(writeBuffer));

    // Simple Field (zone5)
    writeSimpleField("zone5", zone5, writeBoolean(writeBuffer));

    // Simple Field (zone4)
    writeSimpleField("zone4", zone4, writeBoolean(writeBuffer));

    // Simple Field (zone3)
    writeSimpleField("zone3", zone3, writeBoolean(writeBuffer));

    // Simple Field (zone2)
    writeSimpleField("zone2", zone2, writeBoolean(writeBuffer));

    // Simple Field (zone1)
    writeSimpleField("zone1", zone1, writeBoolean(writeBuffer));

    // Simple Field (zone0)
    writeSimpleField("zone0", zone0, writeBoolean(writeBuffer));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean unswitchedZone = getUnswitchedZone();
    writeBuffer.writeVirtual("unswitchedZone", unswitchedZone);

    writeBuffer.popContext("HVACZoneList");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    HVACZoneList _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (expansion)
    lengthInBits += 1;

    // Simple field (zone6)
    lengthInBits += 1;

    // Simple field (zone5)
    lengthInBits += 1;

    // Simple field (zone4)
    lengthInBits += 1;

    // Simple field (zone3)
    lengthInBits += 1;

    // Simple field (zone2)
    lengthInBits += 1;

    // Simple field (zone1)
    lengthInBits += 1;

    // Simple field (zone0)
    lengthInBits += 1;

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static HVACZoneList staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("HVACZoneList");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean expansion = readSimpleField("expansion", readBoolean(readBuffer));

    boolean zone6 = readSimpleField("zone6", readBoolean(readBuffer));

    boolean zone5 = readSimpleField("zone5", readBoolean(readBuffer));

    boolean zone4 = readSimpleField("zone4", readBoolean(readBuffer));

    boolean zone3 = readSimpleField("zone3", readBoolean(readBuffer));

    boolean zone2 = readSimpleField("zone2", readBoolean(readBuffer));

    boolean zone1 = readSimpleField("zone1", readBoolean(readBuffer));

    boolean zone0 = readSimpleField("zone0", readBoolean(readBuffer));
    boolean unswitchedZone = readVirtualField("unswitchedZone", boolean.class, zone0);

    readBuffer.closeContext("HVACZoneList");
    // Create the instance
    HVACZoneList _hVACZoneList;
    _hVACZoneList = new HVACZoneList(expansion, zone6, zone5, zone4, zone3, zone2, zone1, zone0);
    return _hVACZoneList;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HVACZoneList)) {
      return false;
    }
    HVACZoneList that = (HVACZoneList) o;
    return (getExpansion() == that.getExpansion())
        && (getZone6() == that.getZone6())
        && (getZone5() == that.getZone5())
        && (getZone4() == that.getZone4())
        && (getZone3() == that.getZone3())
        && (getZone2() == that.getZone2())
        && (getZone1() == that.getZone1())
        && (getZone0() == that.getZone0())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getExpansion(),
        getZone6(),
        getZone5(),
        getZone4(),
        getZone3(),
        getZone2(),
        getZone1(),
        getZone0());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
