/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum HVACSensorStatus {
  NO_ERROR_OPERATING_NORMALLY((short) 0x00),
  SENSOR_OPERATING_IN_RELAXED_ACCURACY_BAND((short) 0x01),
  SENSOR_OUT_OF_CALIBRATION((short) 0x02),
  SENSOR_TOTAL_FAILURE((short) 0x03);
  private static final Map<Short, HVACSensorStatus> map;

  static {
    map = new HashMap<>();
    for (HVACSensorStatus value : HVACSensorStatus.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  HVACSensorStatus(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static HVACSensorStatus enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
