/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetConfirmedServiceRequestReadPropertyMultiple extends BACnetConfirmedServiceRequest
    implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.READ_PROPERTY_MULTIPLE;
  }

  // Properties.
  protected final List<BACnetReadAccessSpecification> data;

  // Arguments.
  protected final Long serviceRequestPayloadLength;
  protected final Long serviceRequestLength;

  public BACnetConfirmedServiceRequestReadPropertyMultiple(
      List<BACnetReadAccessSpecification> data,
      Long serviceRequestPayloadLength,
      Long serviceRequestLength) {
    super(serviceRequestLength);
    this.data = data;
    this.serviceRequestPayloadLength = serviceRequestPayloadLength;
    this.serviceRequestLength = serviceRequestLength;
  }

  public List<BACnetReadAccessSpecification> getData() {
    return data;
  }

  @Override
  protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConfirmedServiceRequestReadPropertyMultiple");

    // Array Field (data)
    writeComplexTypeArrayField("data", data, writeBuffer);

    writeBuffer.popContext("BACnetConfirmedServiceRequestReadPropertyMultiple");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetConfirmedServiceRequestReadPropertyMultiple _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Array field
    if (data != null) {
      for (Message element : data) {
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static BACnetConfirmedServiceRequestBuilder
      staticParseBACnetConfirmedServiceRequestBuilder(
          ReadBuffer readBuffer, Long serviceRequestPayloadLength, Long serviceRequestLength)
          throws ParseException {
    readBuffer.pullContext("BACnetConfirmedServiceRequestReadPropertyMultiple");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    List<BACnetReadAccessSpecification> data =
        readLengthArrayField(
            "data",
            readComplex(() -> BACnetReadAccessSpecification.staticParse(readBuffer), readBuffer),
            serviceRequestPayloadLength);

    readBuffer.closeContext("BACnetConfirmedServiceRequestReadPropertyMultiple");
    // Create the instance
    return new BACnetConfirmedServiceRequestReadPropertyMultipleBuilderImpl(
        data, serviceRequestPayloadLength, serviceRequestLength);
  }

  public static class BACnetConfirmedServiceRequestReadPropertyMultipleBuilderImpl
      implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
    private final List<BACnetReadAccessSpecification> data;
    private final Long serviceRequestPayloadLength;
    private final Long serviceRequestLength;

    public BACnetConfirmedServiceRequestReadPropertyMultipleBuilderImpl(
        List<BACnetReadAccessSpecification> data,
        Long serviceRequestPayloadLength,
        Long serviceRequestLength) {
      this.data = data;
      this.serviceRequestPayloadLength = serviceRequestPayloadLength;
      this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetConfirmedServiceRequestReadPropertyMultiple build(Long serviceRequestLength) {

      BACnetConfirmedServiceRequestReadPropertyMultiple
          bACnetConfirmedServiceRequestReadPropertyMultiple =
              new BACnetConfirmedServiceRequestReadPropertyMultiple(
                  data, serviceRequestPayloadLength, serviceRequestLength);
      return bACnetConfirmedServiceRequestReadPropertyMultiple;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConfirmedServiceRequestReadPropertyMultiple)) {
      return false;
    }
    BACnetConfirmedServiceRequestReadPropertyMultiple that =
        (BACnetConfirmedServiceRequestReadPropertyMultiple) o;
    return (getData() == that.getData()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
