/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class BACnetApplicationTag implements Message {

  // Abstract accessors for discriminator values.

  // Properties.
  protected final BACnetTagHeader header;

  public BACnetApplicationTag(BACnetTagHeader header) {
    super();
    this.header = header;
  }

  public BACnetTagHeader getHeader() {
    return header;
  }

  public short getActualTagNumber() {
    return (short) (getHeader().getActualTagNumber());
  }

  public long getActualLength() {
    return (long) (getHeader().getActualLength());
  }

  protected abstract void serializeBACnetApplicationTagChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetApplicationTag");

    // Simple Field (header)
    writeSimpleField("header", header, writeComplex(writeBuffer));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short actualTagNumber = getActualTagNumber();
    writeBuffer.writeVirtual("actualTagNumber", actualTagNumber);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    long actualLength = getActualLength();
    writeBuffer.writeVirtual("actualLength", actualLength);

    // Switch field (Serialize the sub-type)
    serializeBACnetApplicationTagChild(writeBuffer);

    writeBuffer.popContext("BACnetApplicationTag");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetApplicationTag _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (header)
    lengthInBits += header.getLengthInBits();

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static BACnetApplicationTag staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetApplicationTag");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetTagHeader header =
        readSimpleField(
            "header", readComplex(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer));
    // Validation
    if (!((header.getTagClass()) == (TagClass.APPLICATION_TAGS))) {
      throw new ParseValidationException("should be a application tag");
    }
    short actualTagNumber =
        readVirtualField("actualTagNumber", short.class, header.getActualTagNumber());
    long actualLength = readVirtualField("actualLength", long.class, header.getActualLength());

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    BACnetApplicationTagBuilder builder = null;
    if (EvaluationHelper.equals(actualTagNumber, (short) 0x0)) {
      builder = BACnetApplicationTagNull.staticParseBACnetApplicationTagBuilder(readBuffer);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0x1)) {
      builder =
          BACnetApplicationTagBoolean.staticParseBACnetApplicationTagBuilder(readBuffer, header);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0x2)) {
      builder =
          BACnetApplicationTagUnsignedInteger.staticParseBACnetApplicationTagBuilder(
              readBuffer, header);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0x3)) {
      builder =
          BACnetApplicationTagSignedInteger.staticParseBACnetApplicationTagBuilder(
              readBuffer, header);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0x4)) {
      builder = BACnetApplicationTagReal.staticParseBACnetApplicationTagBuilder(readBuffer);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0x5)) {
      builder = BACnetApplicationTagDouble.staticParseBACnetApplicationTagBuilder(readBuffer);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0x6)) {
      builder =
          BACnetApplicationTagOctetString.staticParseBACnetApplicationTagBuilder(
              readBuffer, header);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0x7)) {
      builder =
          BACnetApplicationTagCharacterString.staticParseBACnetApplicationTagBuilder(
              readBuffer, header);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0x8)) {
      builder =
          BACnetApplicationTagBitString.staticParseBACnetApplicationTagBuilder(readBuffer, header);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0x9)) {
      builder =
          BACnetApplicationTagEnumerated.staticParseBACnetApplicationTagBuilder(readBuffer, header);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0xA)) {
      builder = BACnetApplicationTagDate.staticParseBACnetApplicationTagBuilder(readBuffer);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0xB)) {
      builder = BACnetApplicationTagTime.staticParseBACnetApplicationTagBuilder(readBuffer);
    } else if (EvaluationHelper.equals(actualTagNumber, (short) 0xC)) {
      builder =
          BACnetApplicationTagObjectIdentifier.staticParseBACnetApplicationTagBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "actualTagNumber="
              + actualTagNumber
              + "]");
    }

    readBuffer.closeContext("BACnetApplicationTag");
    // Create the instance
    BACnetApplicationTag _bACnetApplicationTag = builder.build(header);
    return _bACnetApplicationTag;
  }

  public interface BACnetApplicationTagBuilder {
    BACnetApplicationTag build(BACnetTagHeader header);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetApplicationTag)) {
      return false;
    }
    BACnetApplicationTag that = (BACnetApplicationTag) o;
    return (getHeader() == that.getHeader()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getHeader());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
