/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DiscoveryConfiguration is the corresponding interface of DiscoveryConfiguration
type DiscoveryConfiguration interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// IsDiscoveryConfiguration is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDiscoveryConfiguration()
	// CreateBuilder creates a DiscoveryConfigurationBuilder
	CreateDiscoveryConfigurationBuilder() DiscoveryConfigurationBuilder
}

// _DiscoveryConfiguration is the data-structure of this message
type _DiscoveryConfiguration struct {
	ExtensionObjectDefinitionContract
}

var _ DiscoveryConfiguration = (*_DiscoveryConfiguration)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_DiscoveryConfiguration)(nil)

// NewDiscoveryConfiguration factory function for _DiscoveryConfiguration
func NewDiscoveryConfiguration() *_DiscoveryConfiguration {
	_result := &_DiscoveryConfiguration{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DiscoveryConfigurationBuilder is a builder for DiscoveryConfiguration
type DiscoveryConfigurationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() DiscoveryConfigurationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the DiscoveryConfiguration or returns an error if something is wrong
	Build() (DiscoveryConfiguration, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DiscoveryConfiguration
}

// NewDiscoveryConfigurationBuilder() creates a DiscoveryConfigurationBuilder
func NewDiscoveryConfigurationBuilder() DiscoveryConfigurationBuilder {
	return &_DiscoveryConfigurationBuilder{_DiscoveryConfiguration: new(_DiscoveryConfiguration)}
}

type _DiscoveryConfigurationBuilder struct {
	*_DiscoveryConfiguration

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (DiscoveryConfigurationBuilder) = (*_DiscoveryConfigurationBuilder)(nil)

func (b *_DiscoveryConfigurationBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._DiscoveryConfiguration
}

func (b *_DiscoveryConfigurationBuilder) WithMandatoryFields() DiscoveryConfigurationBuilder {
	return b
}

func (b *_DiscoveryConfigurationBuilder) Build() (DiscoveryConfiguration, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._DiscoveryConfiguration.deepCopy(), nil
}

func (b *_DiscoveryConfigurationBuilder) MustBuild() DiscoveryConfiguration {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DiscoveryConfigurationBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_DiscoveryConfigurationBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_DiscoveryConfigurationBuilder) DeepCopy() any {
	_copy := b.CreateDiscoveryConfigurationBuilder().(*_DiscoveryConfigurationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateDiscoveryConfigurationBuilder creates a DiscoveryConfigurationBuilder
func (b *_DiscoveryConfiguration) CreateDiscoveryConfigurationBuilder() DiscoveryConfigurationBuilder {
	if b == nil {
		return NewDiscoveryConfigurationBuilder()
	}
	return &_DiscoveryConfigurationBuilder{_DiscoveryConfiguration: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DiscoveryConfiguration) GetExtensionId() int32 {
	return int32(12892)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DiscoveryConfiguration) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

// Deprecated: use the interface for direct cast
func CastDiscoveryConfiguration(structType any) DiscoveryConfiguration {
	if casted, ok := structType.(DiscoveryConfiguration); ok {
		return casted
	}
	if casted, ok := structType.(*DiscoveryConfiguration); ok {
		return *casted
	}
	return nil
}

func (m *_DiscoveryConfiguration) GetTypeName() string {
	return "DiscoveryConfiguration"
}

func (m *_DiscoveryConfiguration) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_DiscoveryConfiguration) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_DiscoveryConfiguration) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__discoveryConfiguration DiscoveryConfiguration, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DiscoveryConfiguration"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DiscoveryConfiguration")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("DiscoveryConfiguration"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DiscoveryConfiguration")
	}

	return m, nil
}

func (m *_DiscoveryConfiguration) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DiscoveryConfiguration) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DiscoveryConfiguration"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DiscoveryConfiguration")
		}

		if popErr := writeBuffer.PopContext("DiscoveryConfiguration"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DiscoveryConfiguration")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DiscoveryConfiguration) IsDiscoveryConfiguration() {}

func (m *_DiscoveryConfiguration) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DiscoveryConfiguration) deepCopy() *_DiscoveryConfiguration {
	if m == nil {
		return nil
	}
	_DiscoveryConfigurationCopy := &_DiscoveryConfiguration{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
	}
	_DiscoveryConfigurationCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _DiscoveryConfigurationCopy
}

func (m *_DiscoveryConfiguration) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
