/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesBoolean is the corresponding interface of BACnetPropertyStatesBoolean
type BACnetPropertyStatesBoolean interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetBooleanValue returns BooleanValue (property field)
	GetBooleanValue() BACnetContextTagBoolean
	// IsBACnetPropertyStatesBoolean is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesBoolean()
	// CreateBuilder creates a BACnetPropertyStatesBooleanBuilder
	CreateBACnetPropertyStatesBooleanBuilder() BACnetPropertyStatesBooleanBuilder
}

// _BACnetPropertyStatesBoolean is the data-structure of this message
type _BACnetPropertyStatesBoolean struct {
	BACnetPropertyStatesContract
	BooleanValue BACnetContextTagBoolean
}

var _ BACnetPropertyStatesBoolean = (*_BACnetPropertyStatesBoolean)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesBoolean)(nil)

// NewBACnetPropertyStatesBoolean factory function for _BACnetPropertyStatesBoolean
func NewBACnetPropertyStatesBoolean(peekedTagHeader BACnetTagHeader, booleanValue BACnetContextTagBoolean) *_BACnetPropertyStatesBoolean {
	if booleanValue == nil {
		panic("booleanValue of type BACnetContextTagBoolean for BACnetPropertyStatesBoolean must not be nil")
	}
	_result := &_BACnetPropertyStatesBoolean{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		BooleanValue:                 booleanValue,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesBooleanBuilder is a builder for BACnetPropertyStatesBoolean
type BACnetPropertyStatesBooleanBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(booleanValue BACnetContextTagBoolean) BACnetPropertyStatesBooleanBuilder
	// WithBooleanValue adds BooleanValue (property field)
	WithBooleanValue(BACnetContextTagBoolean) BACnetPropertyStatesBooleanBuilder
	// WithBooleanValueBuilder adds BooleanValue (property field) which is build by the builder
	WithBooleanValueBuilder(func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetPropertyStatesBooleanBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesBoolean or returns an error if something is wrong
	Build() (BACnetPropertyStatesBoolean, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesBoolean
}

// NewBACnetPropertyStatesBooleanBuilder() creates a BACnetPropertyStatesBooleanBuilder
func NewBACnetPropertyStatesBooleanBuilder() BACnetPropertyStatesBooleanBuilder {
	return &_BACnetPropertyStatesBooleanBuilder{_BACnetPropertyStatesBoolean: new(_BACnetPropertyStatesBoolean)}
}

type _BACnetPropertyStatesBooleanBuilder struct {
	*_BACnetPropertyStatesBoolean

	parentBuilder *_BACnetPropertyStatesBuilder

	collectedErr []error
}

var _ (BACnetPropertyStatesBooleanBuilder) = (*_BACnetPropertyStatesBooleanBuilder)(nil)

func (b *_BACnetPropertyStatesBooleanBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesBoolean
}

func (b *_BACnetPropertyStatesBooleanBuilder) WithMandatoryFields(booleanValue BACnetContextTagBoolean) BACnetPropertyStatesBooleanBuilder {
	return b.WithBooleanValue(booleanValue)
}

func (b *_BACnetPropertyStatesBooleanBuilder) WithBooleanValue(booleanValue BACnetContextTagBoolean) BACnetPropertyStatesBooleanBuilder {
	b.BooleanValue = booleanValue
	return b
}

func (b *_BACnetPropertyStatesBooleanBuilder) WithBooleanValueBuilder(builderSupplier func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetPropertyStatesBooleanBuilder {
	builder := builderSupplier(b.BooleanValue.CreateBACnetContextTagBooleanBuilder())
	var err error
	b.BooleanValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesBooleanBuilder) Build() (BACnetPropertyStatesBoolean, error) {
	if b.BooleanValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'booleanValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyStatesBoolean.deepCopy(), nil
}

func (b *_BACnetPropertyStatesBooleanBuilder) MustBuild() BACnetPropertyStatesBoolean {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesBooleanBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesBooleanBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesBooleanBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesBooleanBuilder().(*_BACnetPropertyStatesBooleanBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyStatesBooleanBuilder creates a BACnetPropertyStatesBooleanBuilder
func (b *_BACnetPropertyStatesBoolean) CreateBACnetPropertyStatesBooleanBuilder() BACnetPropertyStatesBooleanBuilder {
	if b == nil {
		return NewBACnetPropertyStatesBooleanBuilder()
	}
	return &_BACnetPropertyStatesBooleanBuilder{_BACnetPropertyStatesBoolean: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesBoolean) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesBoolean) GetBooleanValue() BACnetContextTagBoolean {
	return m.BooleanValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesBoolean(structType any) BACnetPropertyStatesBoolean {
	if casted, ok := structType.(BACnetPropertyStatesBoolean); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesBoolean); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesBoolean) GetTypeName() string {
	return "BACnetPropertyStatesBoolean"
}

func (m *_BACnetPropertyStatesBoolean) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (booleanValue)
	lengthInBits += m.BooleanValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesBoolean) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesBoolean) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesBoolean BACnetPropertyStatesBoolean, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesBoolean"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesBoolean")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	booleanValue, err := ReadSimpleField[BACnetContextTagBoolean](ctx, "booleanValue", ReadComplex[BACnetContextTagBoolean](BACnetContextTagParseWithBufferProducer[BACnetContextTagBoolean]((uint8)(peekedTagNumber), (BACnetDataType)(BACnetDataType_BOOLEAN)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'booleanValue' field"))
	}
	m.BooleanValue = booleanValue

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesBoolean"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesBoolean")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesBoolean) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesBoolean) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesBoolean"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesBoolean")
		}

		if err := WriteSimpleField[BACnetContextTagBoolean](ctx, "booleanValue", m.GetBooleanValue(), WriteComplex[BACnetContextTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'booleanValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesBoolean"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesBoolean")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesBoolean) IsBACnetPropertyStatesBoolean() {}

func (m *_BACnetPropertyStatesBoolean) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesBoolean) deepCopy() *_BACnetPropertyStatesBoolean {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesBooleanCopy := &_BACnetPropertyStatesBoolean{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetContextTagBoolean](m.BooleanValue),
	}
	_BACnetPropertyStatesBooleanCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesBooleanCopy
}

func (m *_BACnetPropertyStatesBoolean) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
