/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesAccessEvent is the corresponding interface of BACnetPropertyStatesAccessEvent
type BACnetPropertyStatesAccessEvent interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetAccessEvent returns AccessEvent (property field)
	GetAccessEvent() BACnetAccessEventTagged
	// IsBACnetPropertyStatesAccessEvent is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesAccessEvent()
	// CreateBuilder creates a BACnetPropertyStatesAccessEventBuilder
	CreateBACnetPropertyStatesAccessEventBuilder() BACnetPropertyStatesAccessEventBuilder
}

// _BACnetPropertyStatesAccessEvent is the data-structure of this message
type _BACnetPropertyStatesAccessEvent struct {
	BACnetPropertyStatesContract
	AccessEvent BACnetAccessEventTagged
}

var _ BACnetPropertyStatesAccessEvent = (*_BACnetPropertyStatesAccessEvent)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesAccessEvent)(nil)

// NewBACnetPropertyStatesAccessEvent factory function for _BACnetPropertyStatesAccessEvent
func NewBACnetPropertyStatesAccessEvent(peekedTagHeader BACnetTagHeader, accessEvent BACnetAccessEventTagged) *_BACnetPropertyStatesAccessEvent {
	if accessEvent == nil {
		panic("accessEvent of type BACnetAccessEventTagged for BACnetPropertyStatesAccessEvent must not be nil")
	}
	_result := &_BACnetPropertyStatesAccessEvent{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		AccessEvent:                  accessEvent,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesAccessEventBuilder is a builder for BACnetPropertyStatesAccessEvent
type BACnetPropertyStatesAccessEventBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(accessEvent BACnetAccessEventTagged) BACnetPropertyStatesAccessEventBuilder
	// WithAccessEvent adds AccessEvent (property field)
	WithAccessEvent(BACnetAccessEventTagged) BACnetPropertyStatesAccessEventBuilder
	// WithAccessEventBuilder adds AccessEvent (property field) which is build by the builder
	WithAccessEventBuilder(func(BACnetAccessEventTaggedBuilder) BACnetAccessEventTaggedBuilder) BACnetPropertyStatesAccessEventBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesAccessEvent or returns an error if something is wrong
	Build() (BACnetPropertyStatesAccessEvent, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesAccessEvent
}

// NewBACnetPropertyStatesAccessEventBuilder() creates a BACnetPropertyStatesAccessEventBuilder
func NewBACnetPropertyStatesAccessEventBuilder() BACnetPropertyStatesAccessEventBuilder {
	return &_BACnetPropertyStatesAccessEventBuilder{_BACnetPropertyStatesAccessEvent: new(_BACnetPropertyStatesAccessEvent)}
}

type _BACnetPropertyStatesAccessEventBuilder struct {
	*_BACnetPropertyStatesAccessEvent

	parentBuilder *_BACnetPropertyStatesBuilder

	collectedErr []error
}

var _ (BACnetPropertyStatesAccessEventBuilder) = (*_BACnetPropertyStatesAccessEventBuilder)(nil)

func (b *_BACnetPropertyStatesAccessEventBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesAccessEvent
}

func (b *_BACnetPropertyStatesAccessEventBuilder) WithMandatoryFields(accessEvent BACnetAccessEventTagged) BACnetPropertyStatesAccessEventBuilder {
	return b.WithAccessEvent(accessEvent)
}

func (b *_BACnetPropertyStatesAccessEventBuilder) WithAccessEvent(accessEvent BACnetAccessEventTagged) BACnetPropertyStatesAccessEventBuilder {
	b.AccessEvent = accessEvent
	return b
}

func (b *_BACnetPropertyStatesAccessEventBuilder) WithAccessEventBuilder(builderSupplier func(BACnetAccessEventTaggedBuilder) BACnetAccessEventTaggedBuilder) BACnetPropertyStatesAccessEventBuilder {
	builder := builderSupplier(b.AccessEvent.CreateBACnetAccessEventTaggedBuilder())
	var err error
	b.AccessEvent, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetAccessEventTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesAccessEventBuilder) Build() (BACnetPropertyStatesAccessEvent, error) {
	if b.AccessEvent == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'accessEvent' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyStatesAccessEvent.deepCopy(), nil
}

func (b *_BACnetPropertyStatesAccessEventBuilder) MustBuild() BACnetPropertyStatesAccessEvent {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesAccessEventBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesAccessEventBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesAccessEventBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesAccessEventBuilder().(*_BACnetPropertyStatesAccessEventBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyStatesAccessEventBuilder creates a BACnetPropertyStatesAccessEventBuilder
func (b *_BACnetPropertyStatesAccessEvent) CreateBACnetPropertyStatesAccessEventBuilder() BACnetPropertyStatesAccessEventBuilder {
	if b == nil {
		return NewBACnetPropertyStatesAccessEventBuilder()
	}
	return &_BACnetPropertyStatesAccessEventBuilder{_BACnetPropertyStatesAccessEvent: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesAccessEvent) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesAccessEvent) GetAccessEvent() BACnetAccessEventTagged {
	return m.AccessEvent
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesAccessEvent(structType any) BACnetPropertyStatesAccessEvent {
	if casted, ok := structType.(BACnetPropertyStatesAccessEvent); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesAccessEvent); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesAccessEvent) GetTypeName() string {
	return "BACnetPropertyStatesAccessEvent"
}

func (m *_BACnetPropertyStatesAccessEvent) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (accessEvent)
	lengthInBits += m.AccessEvent.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesAccessEvent) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesAccessEvent) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesAccessEvent BACnetPropertyStatesAccessEvent, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesAccessEvent"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesAccessEvent")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	accessEvent, err := ReadSimpleField[BACnetAccessEventTagged](ctx, "accessEvent", ReadComplex[BACnetAccessEventTagged](BACnetAccessEventTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessEvent' field"))
	}
	m.AccessEvent = accessEvent

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesAccessEvent"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesAccessEvent")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesAccessEvent) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesAccessEvent) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesAccessEvent"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesAccessEvent")
		}

		if err := WriteSimpleField[BACnetAccessEventTagged](ctx, "accessEvent", m.GetAccessEvent(), WriteComplex[BACnetAccessEventTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessEvent' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesAccessEvent"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesAccessEvent")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesAccessEvent) IsBACnetPropertyStatesAccessEvent() {}

func (m *_BACnetPropertyStatesAccessEvent) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesAccessEvent) deepCopy() *_BACnetPropertyStatesAccessEvent {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesAccessEventCopy := &_BACnetPropertyStatesAccessEvent{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetAccessEventTagged](m.AccessEvent),
	}
	_BACnetPropertyStatesAccessEventCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesAccessEventCopy
}

func (m *_BACnetPropertyStatesAccessEvent) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
