/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.io;

import com.github.junrar.io.SeekableReadOnlyByteChannel;
import java.io.IOException;
import java.util.LinkedList;
import javax.crypto.Cipher;

public class RawDataIo
implements SeekableReadOnlyByteChannel {
    private Cipher cipher = null;
    private final SeekableReadOnlyByteChannel underlyingByteChannel;
    private boolean isEncrypted = false;
    private final LinkedList<Byte> dataPool = new LinkedList();
    private final byte[] reused = new byte[1];

    public RawDataIo(SeekableReadOnlyByteChannel channel) {
        this.underlyingByteChannel = channel;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public void setCipher(Cipher cipher) {
        this.cipher = cipher;
        this.isEncrypted = true;
    }

    @Override
    public long getPosition() throws IOException {
        return this.underlyingByteChannel.getPosition();
    }

    @Override
    public void setPosition(long pos) throws IOException {
        this.underlyingByteChannel.setPosition(pos);
    }

    @Override
    public int read() throws IOException {
        this.read(this.reused, 0, 1);
        return this.reused[0];
    }

    @Override
    public int read(byte[] buffer, int off, int count) throws IOException {
        byte[] tmp = new byte[count];
        int size = this.readFully(tmp, count);
        System.arraycopy(tmp, 0, buffer, off, count);
        return size;
    }

    @Override
    public int readFully(byte[] buffer, int count) throws IOException {
        if (this.isEncrypted) {
            int i;
            int remainingSize = this.dataPool.size();
            int toRead = count - remainingSize;
            int realRead = toRead + (~toRead + 1 & 0xF);
            byte[] tmp = new byte[realRead];
            if (realRead > 0) {
                this.underlyingByteChannel.readFully(tmp, realRead);
                byte[] decrypted = this.cipher.update(tmp);
                for (i = 0; i < decrypted.length; ++i) {
                    this.dataPool.add(decrypted[i]);
                }
            }
            int realReadSize = 0;
            for (i = 0; i < count && !this.dataPool.isEmpty(); ++i) {
                buffer[i] = this.dataPool.poll();
                ++realReadSize;
            }
            return realReadSize;
        }
        return this.underlyingByteChannel.readFully(buffer, count);
    }

    @Override
    public void close() throws IOException {
        this.underlyingByteChannel.close();
    }
}

