/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetAddJobStatusListenerCodec;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.jet.JobStatusEvent;
import com.hazelcast.jet.JobStatusListener;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.impl.JobEventService;
import com.hazelcast.jet.impl.JobProxy;
import com.hazelcast.jet.impl.client.protocol.task.AbstractJetMessageTask;
import com.hazelcast.jet.impl.operation.AddJobStatusListenerOperation;
import com.hazelcast.spi.impl.eventservice.impl.Registration;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.UUID;

public class JetAddJobStatusListenerMessageTask
extends AbstractJetMessageTask<JetAddJobStatusListenerCodec.RequestParameters, UUID> {
    public JetAddJobStatusListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection, JetAddJobStatusListenerCodec::decodeRequest, JetAddJobStatusListenerCodec::encodeResponse);
    }

    @Override
    protected UUID getLightJobCoordinator() {
        return ((JetAddJobStatusListenerCodec.RequestParameters)this.parameters).lightJobCoordinator;
    }

    @Override
    protected Operation prepareOperation() {
        JobProxy.checkJobStatusListenerSupported(this.nodeEngine);
        long jobId = ((JetAddJobStatusListenerCodec.RequestParameters)this.parameters).jobId;
        JobEventService jobEventService = (JobEventService)this.nodeEngine.getService("hz:impl:jobEventService");
        Registration registration = jobEventService.prepareRegistration(jobId, new ClientJobStatusListener(), ((JetAddJobStatusListenerCodec.RequestParameters)this.parameters).localOnly);
        return new AddJobStatusListenerOperation(jobId, ((JetAddJobStatusListenerCodec.RequestParameters)this.parameters).lightJobCoordinator != null, registration);
    }

    @Override
    protected Object processResponseBeforeSending(Object response) {
        this.endpoint.addListenerDestroyAction(this.getServiceName(), this.getDistributedObjectName(), (UUID)response);
        return response;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:jobEventService";
    }

    @Override
    public String getMethodName() {
        return "addJobStatusListener";
    }

    @Override
    public String getDistributedObjectName() {
        return Util.idToString(((JetAddJobStatusListenerCodec.RequestParameters)this.parameters).jobId);
    }

    @Override
    public String[] actions() {
        return new String[]{"listen"};
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    private class ClientJobStatusListener
    implements JobStatusListener {
        private ClientJobStatusListener() {
        }

        @Override
        public void jobStatusChanged(JobStatusEvent e) {
            if (JetAddJobStatusListenerMessageTask.this.endpoint.isAlive()) {
                JetAddJobStatusListenerMessageTask.this.sendClientMessage(e.getJobId(), JetAddJobStatusListenerCodec.encodeJobStatusEvent(e.getJobId(), e.getPreviousStatus().getId(), e.getNewStatus().getId(), e.getDescription(), e.isUserRequested()));
            }
        }
    }
}

