/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.file;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.UserException;
import org.apache.openmeetings.db.bind.adapter.FileTypeAdapter;
import org.apache.openmeetings.db.bind.adapter.IntAdapter;
import org.apache.openmeetings.db.bind.adapter.LongAdapter;
import org.apache.openmeetings.db.entity.HistoricalEntity;
import org.apache.openmeetings.db.entity.file.FileItemLog;
import org.apache.openmeetings.util.OmFileHelper;

@Entity
@NamedQueries(value={@NamedQuery(name="getFileById", query="SELECT f FROM BaseFileItem f WHERE f.deleted = false AND f.id = :id"), @NamedQuery(name="getAnyFileById", query="SELECT f FROM BaseFileItem f WHERE f.id = :id"), @NamedQuery(name="getFileByHash", query="SELECT f FROM BaseFileItem f WHERE f.deleted = false AND f.hash = :hash"), @NamedQuery(name="getAnyFileByHash", query="SELECT f FROM BaseFileItem f WHERE f.hash = :hash"), @NamedQuery(name="getAllFileItemsForRoom", query="SELECT f FROM BaseFileItem f WHERE f.deleted = false AND f.type <> :folder AND (f.roomId IS NULL OR f.roomId = :roomId) AND (f.groupId IS NULL OR f.groupId IN :groups) AND f.ownerId IS NULL AND f.name LIKE :name ORDER BY f.name"), @NamedQuery(name="getFileItemsByIds", query="SELECT f FROM BaseFileItem f WHERE f.deleted = false AND f.id IN :ids")})
@Table(name="om_file", indexes={@Index(name="file_hash_idx", columnList="hash", unique=true)})
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
public abstract class BaseFileItem
extends HistoricalEntity
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    @XmlTransient
    private Long id;
    @Column(name="name")
    @XmlElement(name="fileName", required=false)
    private String name;
    @Column(name="hash")
    @XmlElement(name="fileHash", required=false)
    private String hash;
    @Column(name="parent_item_id")
    @XmlElement(name="parentFileExplorerItemId", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long parentId;
    @Column(name="room_id")
    @XmlElement(name="room_id", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long roomId;
    @Column(name="owner_id")
    @XmlElement(name="ownerId", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long ownerId;
    @Column(name="inserted_by")
    @XmlElement(name="insertedBy", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long insertedBy;
    @Column(name="width")
    @XmlElement(name="width", required=false)
    @XmlJavaTypeAdapter(value=IntAdapter.class)
    private Integer width;
    @Column(name="height")
    @XmlElement(name="height", required=false)
    @XmlJavaTypeAdapter(value=IntAdapter.class)
    private Integer height;
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    @XmlElement(name="type", required=false)
    @XmlJavaTypeAdapter(value=FileTypeAdapter.class)
    private Type type;
    @Column(name="group_id")
    @XmlElement(name="groupId", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long groupId;
    @Column(name="page_count", nullable=false)
    @XmlElement(name="count", required=false)
    @XmlJavaTypeAdapter(value=IntAdapter.class, type=int.class)
    private int count = 1;
    @Column(name="external_type")
    @XmlElement(name="externalType", required=false)
    private String externalType;
    @Transient
    @XmlTransient
    private List<FileItemLog> log;
    @Transient
    @XmlTransient
    private boolean readOnly;
    private static int pcInheritedFieldCount = HistoricalEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    @Override
    public Long getId() {
        return BaseFileItem.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        BaseFileItem.pcSetid(this, id);
    }

    public String getName() {
        return BaseFileItem.pcGetname(this);
    }

    public void setName(String name) {
        BaseFileItem.pcSetname(this, name);
    }

    public String getHash() {
        return BaseFileItem.pcGethash(this);
    }

    public void setHash(String hash) {
        BaseFileItem.pcSethash(this, hash);
    }

    public Long getParentId() {
        return BaseFileItem.pcGetparentId(this);
    }

    public void setParentId(Long parentId) {
        BaseFileItem.pcSetparentId(this, parentId);
    }

    public Long getRoomId() {
        return BaseFileItem.pcGetroomId(this);
    }

    public void setRoomId(Long roomId) {
        BaseFileItem.pcSetroomId(this, roomId);
    }

    public Long getOwnerId() {
        return BaseFileItem.pcGetownerId(this);
    }

    public void setOwnerId(Long ownerId) {
        BaseFileItem.pcSetownerId(this, ownerId);
    }

    public Long getInsertedBy() {
        return BaseFileItem.pcGetinsertedBy(this);
    }

    public void setInsertedBy(Long insertedBy) {
        BaseFileItem.pcSetinsertedBy(this, insertedBy);
    }

    public Integer getWidth() {
        return BaseFileItem.pcGetwidth(this);
    }

    public void setWidth(Integer width) {
        BaseFileItem.pcSetwidth(this, width);
    }

    public Integer getHeight() {
        return BaseFileItem.pcGetheight(this);
    }

    public void setHeight(Integer height) {
        BaseFileItem.pcSetheight(this, height);
    }

    public Type getType() {
        return BaseFileItem.pcGettype(this);
    }

    public void setType(Type type) {
        BaseFileItem.pcSettype(this, type);
    }

    public List<FileItemLog> getLog() {
        return this.log;
    }

    public void setLog(List<FileItemLog> log) {
        this.log = log;
    }

    public String getFileName(String ext) {
        return ext == null ? BaseFileItem.pcGetname(this) : OmFileHelper.getName((String)BaseFileItem.pcGetname(this), (String)ext);
    }

    public File getFile() {
        return this.getFile(null);
    }

    public Long getGroupId() {
        return BaseFileItem.pcGetgroupId(this);
    }

    public void setGroupId(Long groupId) {
        BaseFileItem.pcSetgroupId(this, groupId);
    }

    public int getCount() {
        return BaseFileItem.pcGetcount(this);
    }

    public void setCount(int count) {
        BaseFileItem.pcSetcount(this, count);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getExternalType() {
        return BaseFileItem.pcGetexternalType(this);
    }

    public void setExternalType(String externalType) {
        BaseFileItem.pcSetexternalType(this, externalType);
    }

    public final File getFile(String ext) {
        File f = null;
        if (!this.isDeleted() && this.getHash() != null) {
            File d = new File(OmFileHelper.getUploadFilesDir(), this.getHash());
            switch (this.getType()) {
                case WML_FILE: {
                    f = OmFileHelper.getFileSafe((File)OmFileHelper.getUploadWmlDir(), (String)this.getHash(), (String)ext, (String)"wml");
                    break;
                }
                case IMAGE: {
                    if (ext == null) {
                        f = OmFileHelper.getFileSafe((File)d, (String)this.getHash(), (String)"png");
                        if (f.exists()) break;
                        f = OmFileHelper.getFileSafe((File)d, (String)this.getHash(), (String)"jpg");
                        break;
                    }
                    f = OmFileHelper.getFileSafe((File)d, (String)this.getHash(), (String)ext);
                    break;
                }
                case RECORDING: {
                    f = OmFileHelper.getFileSafe((File)OmFileHelper.getStreamsHibernateDir(), (String)this.getHash(), (String)ext, (String)"mp4");
                    break;
                }
                case VIDEO: {
                    f = OmFileHelper.getFileSafe((File)d, (String)this.getHash(), (String)ext, (String)"mp4");
                    break;
                }
                case PRESENTATION: {
                    int slide;
                    int n = slide = ext == null ? 0 : NumberUtils.toInt((String)ext, (int)-1);
                    if (slide > -1) {
                        f = new File(d, String.format("%1$s-%2$04d.%3$s", "page", slide, "png"));
                        break;
                    }
                    f = OmFileHelper.getFileSafe((File)d, (String)this.getHash(), (String)ext, (String)"pdf");
                    break;
                }
            }
        }
        return f;
    }

    public final File getOriginal() {
        File[] ff;
        File p;
        File f = this.getFile(Type.PRESENTATION == BaseFileItem.pcGettype(this) ? "pdf" : null);
        if (f != null && (p = f.getParentFile()) != null && p.exists() && (ff = p.listFiles(new OriginalFilter())) != null && ff.length > 0) {
            f = ff[0];
        }
        return f;
    }

    public final boolean exists() {
        return this.exists(null);
    }

    public final boolean exists(String ext) {
        if (this.getId() != null && !this.isDeleted()) {
            File f = this.getFile(ext);
            return f != null && f.exists() && f.isFile();
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (BaseFileItem.pcGethash(this) == null ? 0 : BaseFileItem.pcGethash(this).hashCode());
        result = 31 * result + (BaseFileItem.pcGettype(this) == null ? 0 : BaseFileItem.pcGettype(this).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseFileItem other = (BaseFileItem)obj;
        if (BaseFileItem.pcGethash(this) == null ? BaseFileItem.pcGethash(other) != null : !BaseFileItem.pcGethash(this).equals(BaseFileItem.pcGethash(other))) {
            return false;
        }
        return BaseFileItem.pcGettype(this) == BaseFileItem.pcGettype(other);
    }

    public String toString() {
        return "FileItem [id=" + BaseFileItem.pcGetid(this) + ", name=" + BaseFileItem.pcGetname(this) + ", room=" + BaseFileItem.pcGetroomId(this) + ", type=" + BaseFileItem.pcGettype(this).name() + "]";
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcPCSuperclass = HistoricalEntity.class;
        pcFieldNames = new String[]{"count", "externalType", "groupId", "hash", "height", "id", "insertedBy", "name", "ownerId", "parentId", "roomId", "type", "width"};
        pcFieldTypes = new Class[]{Integer.TYPE, String.class, Long.class, String.class, Integer.class, Long.class, Long.class, String.class, Long.class, Long.class, Long.class, Type.class, Integer.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(BaseFileItem.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"BaseFileItem", null);
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.count = 0;
        this.externalType = null;
        this.groupId = null;
        this.hash = null;
        this.height = null;
        this.id = null;
        this.insertedBy = null;
        this.name = null;
        this.ownerId = null;
        this.parentId = null;
        this.roomId = null;
        this.type = null;
        this.width = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 13 + HistoricalEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.count = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.externalType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.groupId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.hash = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.height = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.insertedBy = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.ownerId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.parentId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.roomId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.type = (Type)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 12: {
                this.width = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.count);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalType);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.groupId);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.hash);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.height);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.insertedBy);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ownerId);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.parentId);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.roomId);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.width);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(BaseFileItem baseFileItem, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(baseFileItem, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.count = baseFileItem.count;
                return;
            }
            case 1: {
                this.externalType = baseFileItem.externalType;
                return;
            }
            case 2: {
                this.groupId = baseFileItem.groupId;
                return;
            }
            case 3: {
                this.hash = baseFileItem.hash;
                return;
            }
            case 4: {
                this.height = baseFileItem.height;
                return;
            }
            case 5: {
                this.id = baseFileItem.id;
                return;
            }
            case 6: {
                this.insertedBy = baseFileItem.insertedBy;
                return;
            }
            case 7: {
                this.name = baseFileItem.name;
                return;
            }
            case 8: {
                this.ownerId = baseFileItem.ownerId;
                return;
            }
            case 9: {
                this.parentId = baseFileItem.parentId;
                return;
            }
            case 10: {
                this.roomId = baseFileItem.roomId;
                return;
            }
            case 11: {
                this.type = baseFileItem.type;
                return;
            }
            case 12: {
                this.width = baseFileItem.width;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        BaseFileItem baseFileItem = (BaseFileItem)object;
        if (baseFileItem.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(baseFileItem, nArray[i]);
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        super.pcCopyKeyFieldsFromObjectId(fieldConsumer, object);
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(5 + pcInheritedFieldCount, (Object)longId.getId());
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(Object object) {
        super.pcCopyKeyFieldsFromObjectId(object);
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    @Override
    public Object pcNewObjectIdInstance(Object object) {
        return new LongId(BaseFileItem.class, (String)object);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        return new LongId(BaseFileItem.class, this.id);
    }

    private static final int pcGetcount(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.count;
        }
        int n = pcInheritedFieldCount + 0;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.count;
    }

    private static final void pcSetcount(BaseFileItem baseFileItem, int n) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.count = n;
            return;
        }
        baseFileItem.pcStateManager.settingIntField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 0, baseFileItem.count, n, 0);
    }

    private static final String pcGetexternalType(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.externalType;
        }
        int n = pcInheritedFieldCount + 1;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.externalType;
    }

    private static final void pcSetexternalType(BaseFileItem baseFileItem, String string) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.externalType = string;
            return;
        }
        baseFileItem.pcStateManager.settingStringField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 1, baseFileItem.externalType, string, 0);
    }

    private static final Long pcGetgroupId(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.groupId;
        }
        int n = pcInheritedFieldCount + 2;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.groupId;
    }

    private static final void pcSetgroupId(BaseFileItem baseFileItem, Long l) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.groupId = l;
            return;
        }
        baseFileItem.pcStateManager.settingObjectField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 2, (Object)baseFileItem.groupId, (Object)l, 0);
    }

    private static final String pcGethash(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.hash;
        }
        int n = pcInheritedFieldCount + 3;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.hash;
    }

    private static final void pcSethash(BaseFileItem baseFileItem, String string) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.hash = string;
            return;
        }
        baseFileItem.pcStateManager.settingStringField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 3, baseFileItem.hash, string, 0);
    }

    private static final Integer pcGetheight(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.height;
        }
        int n = pcInheritedFieldCount + 4;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.height;
    }

    private static final void pcSetheight(BaseFileItem baseFileItem, Integer n) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.height = n;
            return;
        }
        baseFileItem.pcStateManager.settingObjectField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 4, (Object)baseFileItem.height, (Object)n, 0);
    }

    private static final Long pcGetid(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.id;
        }
        int n = pcInheritedFieldCount + 5;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.id;
    }

    private static final void pcSetid(BaseFileItem baseFileItem, Long l) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.id = l;
            return;
        }
        baseFileItem.pcStateManager.settingObjectField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 5, (Object)baseFileItem.id, (Object)l, 0);
    }

    private static final Long pcGetinsertedBy(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.insertedBy;
        }
        int n = pcInheritedFieldCount + 6;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.insertedBy;
    }

    private static final void pcSetinsertedBy(BaseFileItem baseFileItem, Long l) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.insertedBy = l;
            return;
        }
        baseFileItem.pcStateManager.settingObjectField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 6, (Object)baseFileItem.insertedBy, (Object)l, 0);
    }

    private static final String pcGetname(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.name;
        }
        int n = pcInheritedFieldCount + 7;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.name;
    }

    private static final void pcSetname(BaseFileItem baseFileItem, String string) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.name = string;
            return;
        }
        baseFileItem.pcStateManager.settingStringField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 7, baseFileItem.name, string, 0);
    }

    private static final Long pcGetownerId(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.ownerId;
        }
        int n = pcInheritedFieldCount + 8;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.ownerId;
    }

    private static final void pcSetownerId(BaseFileItem baseFileItem, Long l) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.ownerId = l;
            return;
        }
        baseFileItem.pcStateManager.settingObjectField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 8, (Object)baseFileItem.ownerId, (Object)l, 0);
    }

    private static final Long pcGetparentId(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.parentId;
        }
        int n = pcInheritedFieldCount + 9;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.parentId;
    }

    private static final void pcSetparentId(BaseFileItem baseFileItem, Long l) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.parentId = l;
            return;
        }
        baseFileItem.pcStateManager.settingObjectField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 9, (Object)baseFileItem.parentId, (Object)l, 0);
    }

    private static final Long pcGetroomId(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.roomId;
        }
        int n = pcInheritedFieldCount + 10;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.roomId;
    }

    private static final void pcSetroomId(BaseFileItem baseFileItem, Long l) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.roomId = l;
            return;
        }
        baseFileItem.pcStateManager.settingObjectField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 10, (Object)baseFileItem.roomId, (Object)l, 0);
    }

    private static final Type pcGettype(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.type;
        }
        int n = pcInheritedFieldCount + 11;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.type;
    }

    private static final void pcSettype(BaseFileItem baseFileItem, Type type) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.type = type;
            return;
        }
        baseFileItem.pcStateManager.settingObjectField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 11, (Object)baseFileItem.type, (Object)type, 0);
    }

    private static final Integer pcGetwidth(BaseFileItem baseFileItem) {
        if (baseFileItem.pcStateManager == null) {
            return baseFileItem.width;
        }
        int n = pcInheritedFieldCount + 12;
        baseFileItem.pcStateManager.accessingField(n);
        return baseFileItem.width;
    }

    private static final void pcSetwidth(BaseFileItem baseFileItem, Integer n) {
        if (baseFileItem.pcStateManager == null) {
            baseFileItem.width = n;
            return;
        }
        baseFileItem.pcStateManager.settingObjectField((PersistenceCapable)baseFileItem, pcInheritedFieldCount + 12, (Object)baseFileItem.width, (Object)n, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    @XmlType(namespace="org.apache.openmeetings.file")
    public static enum Type {
        FOLDER,
        IMAGE,
        POLL_CHART,
        PRESENTATION,
        RECORDING,
        VIDEO,
        WML_FILE;

    }

    private class OriginalFilter
    implements FileFilter {
        Set<String> exclusions = new HashSet<String>();

        OriginalFilter() {
            this.exclusions.add("png");
            this.exclusions.add("swf");
            if (Type.PRESENTATION == BaseFileItem.this.getType()) {
                this.exclusions.add("pdf");
            }
        }

        @Override
        public boolean accept(File f) {
            String n = f.getName();
            String ext = OmFileHelper.getFileExt((String)n);
            return n.startsWith(BaseFileItem.this.getHash()) && !this.exclusions.contains(ext);
        }
    }
}

