/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.widget.menu;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryAbstractBehavior;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.ui.widget.menu.ContextMenu;

public class ContextMenuBehavior
extends JQueryAbstractBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String INVOKER_CSS_CLASS = "context-menu-invoker";
    private final ContextMenu menu;
    private Component component = null;
    private JQueryAjaxBehavior onContextMenuAjaxBehavior;

    public ContextMenuBehavior(ContextMenu menu) {
        this.menu = (ContextMenu)Args.notNull((Object)menu, (String)"menu");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.component != null) {
            throw new WicketRuntimeException("Behavior is already bound to another component.");
        }
        this.component = component;
        this.component.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)INVOKER_CSS_CLASS))});
        this.onContextMenuAjaxBehavior = this.newOnContextMenuAjaxBehavior(this);
        this.component.add(new Behavior[]{this.onContextMenuAjaxBehavior});
    }

    protected String $() {
        return String.format("jQuery('%s').on('contextmenu', %s);", IJQueryWidget.JQueryWidget.getSelector((Component)this.component), this.onContextMenuAjaxBehavior.getCallbackFunction());
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ContextMenuEvent) {
            this.menu.fireOnContextMenu(target, this.component);
        }
    }

    private JQueryAjaxBehavior newOnContextMenuAjaxBehavior(IJQueryAjaxAware source) {
        return new OnContextMenuAjaxBehavior(source);
    }

    protected static class ContextMenuEvent
    extends JQueryEvent {
        protected ContextMenuEvent() {
        }
    }

    public static class OnContextMenuAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnContextMenuAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            String callback = String.valueOf(super.getCallbackFunctionBody(parameters));
            String bodyHide = String.format("jQuery('.%s').each( function() { jQuery(this).hide(); } );", "context-menu");
            String bodyStop = "return false;";
            return String.format("%s %s %s", bodyHide, callback, bodyStop);
        }

        protected JQueryEvent newEvent() {
            return new ContextMenuEvent();
        }
    }
}

