/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.asm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.apache.openjpa.util.asm.BCClassWriter;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.openjpa.util.asm.RedefinedAttribute;
import org.apache.xbean.asm9.Attribute;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.tree.AbstractInsnNode;
import org.apache.xbean.asm9.tree.ClassNode;
import org.apache.xbean.asm9.tree.FieldInsnNode;
import org.apache.xbean.asm9.tree.InsnList;
import org.apache.xbean.asm9.tree.InsnNode;
import org.apache.xbean.asm9.tree.IntInsnNode;
import org.apache.xbean.asm9.tree.LdcInsnNode;
import org.apache.xbean.asm9.tree.MethodInsnNode;
import org.apache.xbean.asm9.tree.MethodNode;
import org.apache.xbean.asm9.tree.TypeInsnNode;
import org.apache.xbean.asm9.tree.VarInsnNode;

public final class AsmHelper {
    public static final Type TYPE_OBJECT = Type.getType(Object.class);
    private static final char[] PRIMITIVE_DESCRIPTORS = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
    public static final Attribute[] ATTRS = new Attribute[]{new RedefinedAttribute()};

    private AsmHelper() {
    }

    public static ClassNode readClassNode(Class<?> clazz) {
        ClassNode classNode;
        block8: {
            int extPos = clazz.getName().lastIndexOf(46) + 1;
            String className = clazz.getName().substring(extPos);
            InputStream in = clazz.getResourceAsStream(className + ".class");
            try {
                ClassReader cr = new ClassReader(in);
                ClassNode classNode2 = new ClassNode();
                cr.accept(classNode2, ATTRS, 0);
                classNode = classNode2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            in.close();
        }
        return classNode;
    }

    public static ClassNode readClassNode(ClassLoader classLoader, String className) throws ClassNotFoundException {
        ClassReader cr;
        String classResourceName = className.replace(".", "/") + ".class";
        try (InputStream classBytesStream = classLoader.getResourceAsStream(classResourceName);){
            cr = new ClassReader(classBytesStream);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Cannot read ClassNode for class " + className, e);
        }
        ClassNode classNode = new ClassNode();
        cr.accept(classNode, ATTRS, 0);
        return classNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getClassBytes(String typeName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(typeName + ".class");
        if (stream == null) {
            return null;
        }
        try {
            int c;
            byte[] buffer = new byte[1024];
            while ((c = stream.read(buffer)) >= 0) {
                baos.write(buffer, 0, c);
            }
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    public static byte[] toByteArray(ClassNodeTracker cnt) {
        BCClassWriter cw = new BCClassWriter(2, cnt.getClassLoader());
        cnt.getClassNode().accept(cw);
        return cw.toByteArray();
    }

    public static Optional<MethodNode> getMethodNode(ClassNode classNode, Method meth) {
        String mDesc = Type.getMethodDescriptor(meth);
        return classNode.methods.stream().filter(mn -> mn.name.equals(meth.getName()) && mn.desc.equals(mDesc)).findAny();
    }

    public static Optional<MethodNode> getMethodNode(ClassNode classNode, String methodName, Class<?> returnType, Class<?> ... paramTypes) {
        Type[] parms = (Type[])Arrays.stream(paramTypes).map(Type::getType).toArray(Type[]::new);
        String mDesc = Type.getMethodDescriptor(Type.getType(returnType), parms);
        return classNode.methods.stream().filter(mn -> mn.name.equals(methodName) && mn.desc.equals(mDesc)).findAny();
    }

    public static int getReturnInsn(Class<?> type) {
        if (type.equals(Void.TYPE)) {
            return 177;
        }
        if (type.isPrimitive()) {
            if (Integer.TYPE.equals(type)) {
                return 172;
            }
            if (Boolean.TYPE.equals(type)) {
                return 172;
            }
            if (Character.TYPE.equals(type)) {
                return 172;
            }
            if (Byte.TYPE.equals(type)) {
                return 172;
            }
            if (Short.TYPE.equals(type)) {
                return 172;
            }
            if (Float.TYPE.equals(type)) {
                return 174;
            }
            if (Long.TYPE.equals(type)) {
                return 173;
            }
            if (Double.TYPE.equals(type)) {
                return 175;
            }
        }
        return 176;
    }

    public static AbstractInsnNode getLoadConstantInsn(Object val) {
        if (val == null) {
            return new InsnNode(1);
        }
        if (val instanceof Integer) {
            int iVal = (Integer)val;
            switch (iVal) {
                case 0: {
                    return new InsnNode(3);
                }
                case 1: {
                    return new InsnNode(4);
                }
                case 2: {
                    return new InsnNode(5);
                }
                case 3: {
                    return new InsnNode(6);
                }
                case 4: {
                    return new InsnNode(7);
                }
                case 5: {
                    return new InsnNode(8);
                }
            }
            if (iVal < 0 && iVal >= -128 || iVal >= 6 && iVal < 128) {
                return new IntInsnNode(16, iVal);
            }
            if (iVal < -128 && iVal >= Short.MIN_VALUE || iVal >= 128 && iVal < 32768) {
                return new IntInsnNode(17, iVal);
            }
        }
        if (val instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                return new InsnNode(4);
            }
            return new InsnNode(3);
        }
        if (val instanceof Long) {
            if ((Long)val == 0L) {
                return new InsnNode(9);
            }
            if ((Long)val == 1L) {
                return new InsnNode(10);
            }
        }
        if (val instanceof Float) {
            if (((Float)val).floatValue() == 0.0f) {
                return new InsnNode(11);
            }
            if (((Float)val).floatValue() == 1.0f) {
                return new InsnNode(12);
            }
            if (((Float)val).floatValue() == 2.0f) {
                return new InsnNode(13);
            }
        }
        if (val instanceof Double) {
            if ((Double)val == 0.0) {
                return new InsnNode(14);
            }
            if ((Double)val == 1.0) {
                return new InsnNode(15);
            }
        }
        if (val instanceof Class) {
            if (Boolean.TYPE.equals(val)) {
                return new FieldInsnNode(178, Type.getInternalName(Boolean.class), "TYPE", Type.getDescriptor(Class.class));
            }
            if (Character.TYPE.equals(val)) {
                return new FieldInsnNode(178, Type.getInternalName(Character.class), "TYPE", Type.getDescriptor(Class.class));
            }
            if (Integer.TYPE.equals(val)) {
                return new FieldInsnNode(178, Type.getInternalName(Integer.class), "TYPE", Type.getDescriptor(Class.class));
            }
            if (Long.TYPE.equals(val)) {
                return new FieldInsnNode(178, Type.getInternalName(Long.class), "TYPE", Type.getDescriptor(Class.class));
            }
            if (Byte.TYPE.equals(val)) {
                return new FieldInsnNode(178, Type.getInternalName(Byte.class), "TYPE", Type.getDescriptor(Class.class));
            }
            if (Short.TYPE.equals(val)) {
                return new FieldInsnNode(178, Type.getInternalName(Short.class), "TYPE", Type.getDescriptor(Class.class));
            }
            if (Float.TYPE.equals(val)) {
                return new FieldInsnNode(178, Type.getInternalName(Float.class), "TYPE", Type.getDescriptor(Class.class));
            }
            if (Double.TYPE.equals(val)) {
                return new FieldInsnNode(178, Type.getInternalName(Double.class), "TYPE", Type.getDescriptor(Class.class));
            }
            return new LdcInsnNode(Type.getType((Class)val));
        }
        return new LdcInsnNode(val);
    }

    public static int getStoreInsn(Class<?> type) {
        if (type.equals(Void.TYPE)) {
            throw new IllegalArgumentException("Void type cannot be stored");
        }
        if (type.isPrimitive()) {
            if (Integer.TYPE.equals(type)) {
                return 54;
            }
            if (Boolean.TYPE.equals(type)) {
                return 54;
            }
            if (Character.TYPE.equals(type)) {
                return 54;
            }
            if (Byte.TYPE.equals(type)) {
                return 54;
            }
            if (Short.TYPE.equals(type)) {
                return 54;
            }
            if (Float.TYPE.equals(type)) {
                return 56;
            }
            if (Long.TYPE.equals(type)) {
                return 55;
            }
            if (Double.TYPE.equals(type)) {
                return 57;
            }
        }
        return 58;
    }

    public static int getLoadInsn(Class<?> type) {
        if (type.equals(Void.TYPE)) {
            throw new IllegalArgumentException("Void type cannot be loaded");
        }
        if (type.isPrimitive()) {
            if (Integer.TYPE.equals(type)) {
                return 21;
            }
            if (Boolean.TYPE.equals(type)) {
                return 21;
            }
            if (Character.TYPE.equals(type)) {
                return 21;
            }
            if (Byte.TYPE.equals(type)) {
                return 21;
            }
            if (Short.TYPE.equals(type)) {
                return 21;
            }
            if (Float.TYPE.equals(type)) {
                return 23;
            }
            if (Long.TYPE.equals(type)) {
                return 22;
            }
            if (Double.TYPE.equals(type)) {
                return 24;
            }
        }
        return 25;
    }

    public static String[] getInternalNames(Class<?>[] classes) {
        String[] internalNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            internalNames[i] = Type.getInternalName(classes[i]);
        }
        return internalNames;
    }

    public static Type[] getParamTypes(Class<?>[] params) {
        Type[] types = new Type[params.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = Type.getType(params[i]);
        }
        return types;
    }

    public static int getParamIndex(MethodNode methodNode, int varPos) {
        boolean isStatic;
        boolean bl = isStatic = (methodNode.access & 8) > 0;
        if (!isStatic) {
            --varPos;
        }
        Type[] paramTypes = Type.getArgumentTypes(methodNode.desc);
        int pos = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (pos == varPos) {
                return i;
            }
            pos += paramTypes[i].getSize();
        }
        throw new IllegalArgumentException("Cannot determine parameter position " + varPos + " for method " + methodNode.name);
    }

    public static boolean isLoadInsn(AbstractInsnNode insn) {
        return insn.getOpcode() == 25 || insn.getOpcode() == 21 || insn.getOpcode() == 46 || insn.getOpcode() == 22 || insn.getOpcode() == 47 || insn.getOpcode() == 23 || insn.getOpcode() == 48 || insn.getOpcode() == 24 || insn.getOpcode() == 49 || insn.getOpcode() == 51 || insn.getOpcode() == 52 || insn.getOpcode() == 53;
    }

    public static boolean isThisInsn(AbstractInsnNode insn) {
        return insn instanceof VarInsnNode && insn.getOpcode() == 25 && ((VarInsnNode)insn).var == 0;
    }

    public static int getCorrespondingLoadInsn(int storeInsnOpcode) {
        switch (storeInsnOpcode) {
            case 54: {
                return 21;
            }
            case 55: {
                return 22;
            }
            case 56: {
                return 23;
            }
            case 57: {
                return 24;
            }
            case 58: {
                return 25;
            }
            case 79: {
                return 46;
            }
            case 80: {
                return 47;
            }
            case 81: {
                return 48;
            }
            case 82: {
                return 49;
            }
            case 83: {
                return 50;
            }
            case 84: {
                return 51;
            }
            case 85: {
                return 52;
            }
            case 86: {
                return 53;
            }
        }
        throw new IllegalArgumentException("Not a STORE instruction: " + storeInsnOpcode);
    }

    public static int getCorrespondingStoreInsn(int loadInsnOpcode) {
        switch (loadInsnOpcode) {
            case 21: {
                return 54;
            }
            case 22: {
                return 55;
            }
            case 23: {
                return 56;
            }
            case 24: {
                return 57;
            }
            case 25: {
                return 58;
            }
            case 46: {
                return 79;
            }
            case 47: {
                return 80;
            }
            case 48: {
                return 81;
            }
            case 49: {
                return 82;
            }
            case 50: {
                return 83;
            }
            case 51: {
                return 84;
            }
            case 52: {
                return 85;
            }
            case 53: {
                return 86;
            }
        }
        throw new IllegalArgumentException("Not a LOAD instruction: " + loadInsnOpcode);
    }

    public static boolean isPrimitive(String typeDesc, boolean includeVoid) {
        if (typeDesc != null && typeDesc.length() == 1) {
            int i;
            char typeChar = typeDesc.charAt(0);
            int n = i = includeVoid ? 0 : 1;
            while (i < PRIMITIVE_DESCRIPTORS.length) {
                if (PRIMITIVE_DESCRIPTORS[i] == typeChar) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static Class<?> getDescribedClass(ClassLoader classLoader, String typeDesc) {
        if (typeDesc == null || typeDesc.isEmpty()) {
            return null;
        }
        if (typeDesc.charAt(0) == '[') {
            switch (typeDesc.charAt(1)) {
                case 'V': {
                    throw new IllegalArgumentException("There is no such thing as a void array");
                }
                case 'Z': {
                    return boolean[].class;
                }
                case 'C': {
                    return char[].class;
                }
                case 'B': {
                    return byte[].class;
                }
                case 'S': {
                    return short[].class;
                }
                case 'I': {
                    return int[].class;
                }
                case 'F': {
                    return float[].class;
                }
                case 'J': {
                    return long[].class;
                }
                case 'D': {
                    return double[].class;
                }
            }
            Class<?> clazz = AsmHelper.getClass(classLoader, typeDesc.substring(1));
            return Array.newInstance(clazz, 0).getClass();
        }
        switch (typeDesc.charAt(0)) {
            case 'V': {
                return Void.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                if (typeDesc.charAt(typeDesc.length() - 1) != ';') break;
                return AsmHelper.getClass(classLoader, typeDesc.substring(1, typeDesc.length() - 1));
            }
        }
        return AsmHelper.getClass(classLoader, typeDesc);
    }

    public static InsnList throwException(Class type) {
        return AsmHelper.throwException(type, null);
    }

    public static InsnList throwException(Class type, String msg) {
        InsnList instructions = new InsnList();
        instructions.add(new TypeInsnNode(187, Type.getInternalName(type)));
        instructions.add(new InsnNode(89));
        if (msg != null) {
            instructions.add(AsmHelper.getLoadConstantInsn(msg));
        }
        String desc = msg != null ? Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class)) : Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);
        instructions.add(new MethodInsnNode(183, Type.getInternalName(type), "<init>", desc));
        instructions.add(new InsnNode(191));
        return instructions;
    }

    public static Class<?> getClass(ClassLoader classLoader, String internalTypeName) {
        try {
            return Class.forName(internalTypeName.replace("/", "."), false, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    public static int getLocalVarPos(MethodNode meth) {
        Type[] paramTypes = Type.getArgumentTypes(meth.desc);
        int pos = (meth.access & 8) > 0 ? 0 : 1;
        for (Type paramType : paramTypes) {
            pos += paramType.getSize();
        }
        return pos;
    }
}

