/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import io.r2dbc.proxy.ProxyConnectionFactory;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.r2dbc.ProxyConnectionFactoryCustomizer;
import org.springframework.boot.r2dbc.ConnectionFactoryDecorator;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={ConnectionFactory.class, ProxyConnectionFactory.class})
public class R2dbcProxyAutoConfiguration {
    @Bean
    ConnectionFactoryDecorator connectionFactoryDecorator(ObjectProvider<ProxyConnectionFactoryCustomizer> customizers) {
        return connectionFactory -> {
            ProxyConnectionFactory.Builder builder = ProxyConnectionFactory.builder((ConnectionFactory)connectionFactory);
            customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder.build();
        };
    }
}

