/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.JavacTask;
import jpt.sun.source.util.SourcePositions;
import jpt.sun.source.util.Trees;
import jpt30.tools.JavaCompiler;
import jpt30.tools.JavaFileObject;
import jpt30.tools.SimpleJavaFileObject;
import jpt30.tools.ToolProvider;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.datatransfer.PasteType;

public class CreateJavaClassFileFromClipboard
extends PasteType {
    private static final String PUBLIC_MODIFIER = "public";
    private final DataFolder context;
    private final Transferable t;

    public CreateJavaClassFileFromClipboard(DataFolder context, Transferable t) {
        this.context = context;
        this.t = t;
    }

    @Override
    public Transferable paste() throws IOException {
        try {
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (!c.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                return this.t;
            }
            Object copiedData = (String)c.getData(DataFlavor.stringFlavor);
            ClassContent classContent = this.extractPackageAndClassName((String)copiedData);
            if (classContent == null) {
                NotifyDescriptor.Message notifyMsg = new NotifyDescriptor.Message(Bundle.ERR_NotValidClass(), 0);
                DialogDisplayer.getDefault().notifyLater(notifyMsg);
                return this.t;
            }
            Set<FileObject> files = this.context.files();
            if (files.size() != 1) {
                return this.t;
            }
            String path = files.iterator().next().getPath();
            File fileName = new File(path + File.separator + classContent.getClassName() + ".java");
            if (fileName.exists()) {
                NotifyDescriptor.Message notifyMsg = new NotifyDescriptor.Message(Bundle.ERR_ClassAlreadyPresent(classContent.getClassName() + ".java"), 0);
                DialogDisplayer.getDefault().notifyLater(notifyMsg);
                return this.t;
            }
            if (!fileName.createNewFile()) {
                NotifyDescriptor.Message notifyMsg = new NotifyDescriptor.Message(Bundle.ERR_UnableToCreateFile(classContent.getClassName() + ".java"), 0);
                DialogDisplayer.getDefault().notifyLater(notifyMsg);
                return this.t;
            }
            if (classContent.getPackageStartOffset() != -1L && classContent.getPackageEndOffset() != -1L) {
                copiedData = this.removePackage((String)copiedData, classContent.getPackageStartOffset(), classContent.getPackageEndOffset());
            }
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));){
                String packageLocation = this.getPackageNameFromFile(fileName);
                if (packageLocation != null && !packageLocation.isEmpty()) {
                    copiedData = "package " + packageLocation + ";\n" + (String)copiedData;
                }
                bw.write((String)copiedData);
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace(ex);
        }
        return this.t;
    }

    private ClassContent extractPackageAndClassName(String copiedData) {
        long packageEndOffset;
        long packageStartOffset;
        String nonPublicFirstClassName;
        String publicFirstClassName;
        block7: {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            publicFirstClassName = null;
            nonPublicFirstClassName = null;
            packageStartOffset = -1L;
            packageEndOffset = -1L;
            int counter = 0;
            JavaCompiler.CompilationTask task = compiler.getTask(null, null, null, null, null, Arrays.asList(new MyFileObject(copiedData)));
            SourcePositions sourcePositions = Trees.instance(task).getSourcePositions();
            try {
                for (CompilationUnitTree compilationUnitTree : ((JavacTask)task).parse()) {
                    packageStartOffset = sourcePositions.getStartPosition(compilationUnitTree, compilationUnitTree.getPackage());
                    packageEndOffset = sourcePositions.getEndPosition(compilationUnitTree, compilationUnitTree.getPackage());
                    for (Tree tree : compilationUnitTree.getTypeDecls()) {
                        if (!(tree instanceof ClassTree)) continue;
                        ClassTree classTree = (ClassTree)tree;
                        if (classTree.toString().trim().startsWith(PUBLIC_MODIFIER)) {
                            publicFirstClassName = classTree.getSimpleName().toString();
                            break block7;
                        }
                        if (counter != 0) continue;
                        nonPublicFirstClassName = classTree.getSimpleName().toString();
                        ++counter;
                    }
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
            }
        }
        if (publicFirstClassName != null && !publicFirstClassName.equals("<error>")) {
            return new ClassContent(publicFirstClassName, packageStartOffset, packageEndOffset);
        }
        if (nonPublicFirstClassName != null && !nonPublicFirstClassName.equals("<error>")) {
            return new ClassContent(nonPublicFirstClassName, packageStartOffset, packageEndOffset);
        }
        return null;
    }

    private String removePackage(String copiedCode, long packageStartOffset, long packageEndOffset) {
        return new StringBuilder(copiedCode).delete((int)packageStartOffset, (int)packageEndOffset).toString();
    }

    private String getPackageNameFromFile(File fileName) {
        String packageLocation = null;
        try {
            FileObject data = FileUtil.createData(fileName);
            ClassPath classPath = ClassPath.getClassPath(data, "classpath/source");
            if (classPath != null) {
                packageLocation = classPath.getResourceName(data.getParent(), '.', false);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace(ioe);
        }
        return packageLocation;
    }

    private class ClassContent {
        private final String className;
        private final long packageStartOffset;
        private final long packageEndOffset;

        public ClassContent(String className, long packageStartOffset, long packageEndOffset) {
            this.className = className;
            this.packageStartOffset = packageStartOffset;
            this.packageEndOffset = packageEndOffset;
        }

        public String getClassName() {
            return this.className;
        }

        public long getPackageStartOffset() {
            return this.packageStartOffset;
        }

        public long getPackageEndOffset() {
            return this.packageEndOffset;
        }
    }

    private static class MyFileObject
    extends SimpleJavaFileObject {
        private String text;

        public MyFileObject(String text) {
            super(URI.create("myfo:/Test.java"), JavaFileObject.Kind.SOURCE);
            this.text = text;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.text;
        }
    }
}

