/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class RSAPublicKeyDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final RSAPublicKeyDecoder INSTANCE = new RSAPublicKeyDecoder();

    public RSAPublicKeyDecoder() {
        super(Collections.unmodifiableList(Arrays.asList("ssh-rsa", "rsa-sha2-256", "rsa-sha2-512")));
    }

    @Override
    public PublicKey decodePublicKey(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        String canonicalName = KeyUtils.getCanonicalKeyType(keyType);
        if (!"ssh-rsa".equals(canonicalName)) {
            throw new InvalidKeySpecException("Unexpected key type: " + keyType);
        }
        BigInteger e = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger n = KeyEntryResolver.decodeBigInt(keyData);
        return this.generatePublicKey(new RSAPublicKeySpec(n, e));
    }

    @Override
    public String encodePublicKey(OutputStream s, PublicKey k) throws IOException {
        RSAPublicKey key = ValidateUtils.checkInstanceOf(k, RSAPublicKey.class, "Key must be a RSAPublicKey");
        KeyEntryResolver.encodeString(s, "ssh-rsa");
        KeyEntryResolver.encodeBigInt(s, key.getPublicExponent());
        KeyEntryResolver.encodeBigInt(s, key.getModulus());
        return "ssh-rsa";
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("RSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("RSA");
    }
}

