/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.net.SocketTimeoutException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class RemoteWindow
extends Window {
    private static final Predicate<Window> SPACE_AVAILABLE_PREDICATE = Window.largerThan(0L);

    public RemoteWindow(Channel channel, boolean isClient) {
        super(channel, isClient);
    }

    @Override
    public void init(long size, long packetSize, PropertyResolver resolver) {
        super.init(size, packetSize, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long consume(long len) {
        long remainLen;
        BufferUtils.validateUint32Value((long)len, (String)"Invalid consumption length: %d");
        this.checkInitialized("consume");
        long toConsume = len;
        Object object = this.lock;
        synchronized (object) {
            long current = this.getSize();
            if (current < toConsume) {
                toConsume = current;
            }
            remainLen = current - toConsume;
            this.updateSize(remainLen);
        }
        if (this.log.isDebugEnabled()) {
            if (toConsume != len) {
                this.log.debug("Consume {} by {} (requested {}) down to {}", new Object[]{this, toConsume, len, remainLen});
            } else {
                this.log.debug("Consume {} by {} down to {}", new Object[]{this, toConsume, remainLen});
            }
        }
        return toConsume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(long increment) {
        long expandedSize;
        long initialSize;
        BufferUtils.validateUint32Value((long)increment, (String)"Invalid window expansion size: %d");
        this.checkInitialized("expand");
        Object object = this.lock;
        synchronized (object) {
            initialSize = this.getSize();
            expandedSize = Math.min(initialSize + increment, 0xFFFFFFFFL);
            this.updateSize(expandedSize);
        }
        if (expandedSize - initialSize != increment) {
            this.log.warn("expand({}) window increase from {} by {} too large, set to {}", new Object[]{this, initialSize, increment, expandedSize});
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("expand({}) increase window from {} by {} up to {}", new Object[]{this, initialSize, increment, expandedSize});
        }
    }

    public void waitAndConsume(long len, long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        this.waitAndConsume(len, Duration.ofMillis(maxWaitTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndConsume(long len, Duration maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        BufferUtils.validateUint32Value((long)len, (String)"Invalid wait consume length: %d", (Object)len);
        this.checkInitialized("waitAndConsume");
        if (len == 0L) {
            return;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(RemoteWindow.largerThan(len - 1L), maxWaitTime);
            if (debugEnabled) {
                this.log.debug("waitAndConsume({}) - requested={}, available={}", new Object[]{this, len, this.getSize()});
            }
            this.consume(len);
        }
    }

    public long waitForSpace(long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        return this.waitForSpace(Duration.ofMillis(maxWaitTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForSpace(Duration maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        long available;
        this.checkInitialized("waitForSpace");
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(SPACE_AVAILABLE_PREDICATE, maxWaitTime);
            available = this.getSize();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("waitForSpace({}) available: {}", (Object)this, (Object)available);
        }
        return available;
    }

    protected void waitForCondition(Predicate<? super Window> predicate, Duration maxWaitTime) throws WindowClosedException, InterruptedException, SocketTimeoutException {
        Objects.requireNonNull(predicate, "No condition");
        ValidateUtils.checkTrue((boolean)GenericUtils.isPositive((Duration)maxWaitTime), (String)"Non-positive max. wait time: %s", (Object)maxWaitTime.toString());
        Instant cur = Instant.now();
        Instant waitEnd = cur.plus(maxWaitTime);
        while (this.isOpen() && cur.compareTo(waitEnd) < 0) {
            if (predicate.test(this)) {
                return;
            }
            Duration rem = Duration.between(cur, waitEnd);
            this.lock.wait(rem.toMillis(), rem.getNano() % 1000000);
            cur = Instant.now();
        }
        if (!this.isOpen()) {
            throw new WindowClosedException(this.toString());
        }
        throw new SocketTimeoutException("waitForCondition(" + this + ") timeout exceeded: " + maxWaitTime);
    }
}

