/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import org.codehaus.plexus.util.StringUtils;

public class PathTool {
    public static final String getRelativePath(String basedir, String filename) {
        basedir = PathTool.uppercaseDrive(basedir);
        filename = PathTool.uppercaseDrive(filename);
        if (basedir == null || basedir.length() == 0 || filename == null || filename.length() == 0 || !filename.startsWith(basedir)) {
            return "";
        }
        String separator = PathTool.determineSeparator(filename);
        basedir = StringUtils.chompLast(basedir, separator);
        filename = StringUtils.chompLast(filename, separator);
        String relativeFilename = filename.substring(basedir.length());
        return PathTool.determineRelativePath(relativeFilename, separator);
    }

    public static final String getRelativePath(String filename) {
        if ((filename = PathTool.uppercaseDrive(filename)) == null || filename.length() == 0) {
            return "";
        }
        String separator = PathTool.determineSeparator(filename);
        if (!(filename = StringUtils.chompLast(filename, separator)).startsWith(separator)) {
            filename = String.valueOf(separator) + filename;
        }
        return PathTool.determineRelativePath(filename, separator);
    }

    public static final String getDirectoryComponent(String filename) {
        if (filename == null || filename.length() == 0) {
            return "";
        }
        String separator = PathTool.determineSeparator(filename);
        String directory = StringUtils.chomp(filename, separator);
        if (filename.equals(directory)) {
            return ".";
        }
        return directory;
    }

    private static final String determineRelativePath(String filename, String separator) {
        if (filename.length() == 0) {
            return "";
        }
        int slashCount = StringUtils.countMatches(filename, separator) - 1;
        if (slashCount <= 0) {
            return ".";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < slashCount) {
            sb.append("../");
            ++i;
        }
        return StringUtils.chop(sb.toString());
    }

    private static final String determineSeparator(String filename) {
        int backwardCount;
        int forwardCount = StringUtils.countMatches(filename, "/");
        return forwardCount >= (backwardCount = StringUtils.countMatches(filename, "\\")) ? "/" : "\\";
    }

    static final String uppercaseDrive(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() >= 2 && path.charAt(1) == ':') {
            path = String.valueOf(path.substring(0, 1).toUpperCase()) + path.substring(1);
        }
        return path;
    }

    public static final String calculateLink(String link, String relativePath) {
        if (link.startsWith("/site/")) {
            return link.substring(5);
        }
        if (link.startsWith("/absolute/")) {
            return link.substring(10);
        }
        if (link.indexOf(":") >= 0) {
            return link;
        }
        if (relativePath.equals(".")) {
            if (link.startsWith("/")) {
                return link.substring(1);
            }
            return link;
        }
        if (relativePath.endsWith("/") && link.startsWith("/")) {
            return String.valueOf(relativePath) + "." + link.substring(1);
        }
        if (relativePath.endsWith("/") || link.startsWith("/")) {
            return String.valueOf(relativePath) + link;
        }
        return String.valueOf(relativePath) + "/" + link;
    }
}

